/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.okhttp3.internal.http1;

import com.zoyi.io.socket.okhttp3.HttpUrl;
import com.zoyi.io.socket.okhttp3.internal.Util;
import com.zoyi.io.socket.okhttp3.internal.http.HttpHeaders;
import com.zoyi.io.socket.okhttp3.internal.http1.Http1Codec;
import com.zoyi.io.socket.okhttp3.internal.http1.Http1Codec$AbstractSource;
import com.zoyi.io.socket.okio.Buffer;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.concurrent.TimeUnit;

class Http1Codec$ChunkedSource
extends Http1Codec$AbstractSource {
    private static final long NO_CHUNK_YET = -1L;
    private final HttpUrl url;
    private long bytesRemainingInChunk;
    private boolean hasMoreChunks;
    final /* synthetic */ Http1Codec this$0;

    Http1Codec$ChunkedSource(Http1Codec http1Codec, HttpUrl httpUrl) {
        this.this$0 = http1Codec;
        super(http1Codec, null);
        this.bytesRemainingInChunk = -1L;
        this.hasMoreChunks = true;
        this.url = httpUrl;
    }

    @Override
    public long read(Buffer buffer, long l2) throws IOException {
        long l3;
        if (l2 < 0L) {
            throw new IllegalArgumentException("byteCount < 0: " + l2);
        }
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        if (!this.hasMoreChunks) {
            return -1L;
        }
        if (this.bytesRemainingInChunk == 0L || this.bytesRemainingInChunk == -1L) {
            this.readChunkSize();
            if (!this.hasMoreChunks) {
                return -1L;
            }
        }
        if ((l3 = this.this$0.source.read(buffer, Math.min(l2, this.bytesRemainingInChunk))) == -1L) {
            this.endOfInput(false);
            throw new ProtocolException("unexpected end of stream");
        }
        this.bytesRemainingInChunk -= l3;
        return l3;
    }

    private void readChunkSize() throws IOException {
        if (this.bytesRemainingInChunk != -1L) {
            this.this$0.source.readUtf8LineStrict();
        }
        try {
            this.bytesRemainingInChunk = this.this$0.source.readHexadecimalUnsignedLong();
            String string = this.this$0.source.readUtf8LineStrict().trim();
            if (this.bytesRemainingInChunk < 0L || !string.isEmpty() && !string.startsWith(";")) {
                throw new ProtocolException("expected chunk size and optional extensions but was \"" + this.bytesRemainingInChunk + string + "\"");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new ProtocolException(numberFormatException.getMessage());
        }
        if (this.bytesRemainingInChunk == 0L) {
            this.hasMoreChunks = false;
            HttpHeaders.receiveHeaders(this.this$0.client.cookieJar(), this.url, this.this$0.readHeaders());
            this.endOfInput(true);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.hasMoreChunks && !Util.discard(this, 100, TimeUnit.MILLISECONDS)) {
            this.endOfInput(false);
        }
        this.closed = true;
    }
}

