/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.okhttp3.internal.http;

import com.zoyi.io.socket.okhttp3.Address;
import com.zoyi.io.socket.okhttp3.CertificatePinner;
import com.zoyi.io.socket.okhttp3.HttpUrl;
import com.zoyi.io.socket.okhttp3.Interceptor;
import com.zoyi.io.socket.okhttp3.Interceptor$Chain;
import com.zoyi.io.socket.okhttp3.OkHttpClient;
import com.zoyi.io.socket.okhttp3.Request;
import com.zoyi.io.socket.okhttp3.Request$Builder;
import com.zoyi.io.socket.okhttp3.RequestBody;
import com.zoyi.io.socket.okhttp3.Response;
import com.zoyi.io.socket.okhttp3.Route;
import com.zoyi.io.socket.okhttp3.internal.Util;
import com.zoyi.io.socket.okhttp3.internal.connection.RouteException;
import com.zoyi.io.socket.okhttp3.internal.connection.StreamAllocation;
import com.zoyi.io.socket.okhttp3.internal.http.HttpMethod;
import com.zoyi.io.socket.okhttp3.internal.http.RealInterceptorChain;
import com.zoyi.io.socket.okhttp3.internal.http.UnrepeatableRequestBody;
import com.zoyi.io.socket.okhttp3.internal.http2.ConnectionShutdownException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.HttpRetryException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.security.cert.CertificateException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocketFactory;

public final class RetryAndFollowUpInterceptor
implements Interceptor {
    private static final int MAX_FOLLOW_UPS = 20;
    private final OkHttpClient client;
    private final boolean forWebSocket;
    private StreamAllocation streamAllocation;
    private Object callStackTrace;
    private volatile boolean canceled;

    public RetryAndFollowUpInterceptor(OkHttpClient okHttpClient, boolean bl) {
        this.client = okHttpClient;
        this.forWebSocket = bl;
    }

    public final void cancel() {
        this.canceled = true;
        StreamAllocation streamAllocation = this.streamAllocation;
        if (streamAllocation != null) {
            streamAllocation.cancel();
        }
    }

    public final boolean isCanceled() {
        return this.canceled;
    }

    public final void setCallStackTrace(Object object) {
        this.callStackTrace = object;
    }

    public final StreamAllocation streamAllocation() {
        return this.streamAllocation;
    }

    @Override
    public final Response intercept(Interceptor$Chain interceptor$Chain) throws IOException {
        Object object = interceptor$Chain.request();
        this.streamAllocation = new StreamAllocation(this.client.connectionPool(), this.createAddress(((Request)object).url()), this.callStackTrace);
        int n2 = 0;
        Response response = null;
        while (true) {
            Object object2;
            Response response2;
            if (this.canceled) {
                this.streamAllocation.release();
                throw new IOException("Canceled");
            }
            try {
                try {
                    response2 = ((RealInterceptorChain)interceptor$Chain).proceed((Request)object, this.streamAllocation, null, null);
                }
                catch (RouteException routeException) {
                    if (this.recover(routeException.getLastConnectException(), false, (Request)object)) continue;
                    throw routeException.getLastConnectException();
                }
                catch (IOException iOException) {
                    object2 = iOException;
                    boolean bl = !(iOException instanceof ConnectionShutdownException);
                    if (this.recover((IOException)object2, bl, (Request)object)) continue;
                    throw object2;
                }
            }
            catch (Throwable throwable) {
                this.streamAllocation.streamFailed(null);
                this.streamAllocation.release();
                throw throwable;
            }
            if (response != null) {
                response2 = response2.newBuilder().priorResponse(response.newBuilder().body(null).build()).build();
            }
            if ((object2 = this.followUpRequest(response2)) == null) {
                if (!this.forWebSocket) {
                    this.streamAllocation.release();
                }
                return response2;
            }
            Util.closeQuietly(response2.body());
            if (++n2 > 20) {
                this.streamAllocation.release();
                throw new ProtocolException("Too many follow-up requests: " + n2);
            }
            if (((Request)object2).body() instanceof UnrepeatableRequestBody) {
                this.streamAllocation.release();
                throw new HttpRetryException("Cannot retry streamed HTTP body", response2.code());
            }
            if (!this.sameConnection(response2, ((Request)object2).url())) {
                this.streamAllocation.release();
                this.streamAllocation = new StreamAllocation(this.client.connectionPool(), this.createAddress(((Request)object2).url()), this.callStackTrace);
            } else if (this.streamAllocation.codec() != null) {
                throw new IllegalStateException("Closing the body of " + response2 + " didn't close its backing stream. Bad interceptor?");
            }
            object = object2;
            response = response2;
        }
    }

    private Address createAddress(HttpUrl httpUrl) {
        SSLSocketFactory sSLSocketFactory = null;
        HostnameVerifier hostnameVerifier = null;
        CertificatePinner certificatePinner = null;
        if (httpUrl.isHttps()) {
            sSLSocketFactory = this.client.sslSocketFactory();
            hostnameVerifier = this.client.hostnameVerifier();
            certificatePinner = this.client.certificatePinner();
        }
        return new Address(httpUrl.host(), httpUrl.port(), this.client.dns(), this.client.socketFactory(), sSLSocketFactory, hostnameVerifier, certificatePinner, this.client.proxyAuthenticator(), this.client.proxy(), this.client.protocols(), this.client.connectionSpecs(), this.client.proxySelector());
    }

    private boolean recover(IOException iOException, boolean bl, Request request) {
        this.streamAllocation.streamFailed(iOException);
        if (!this.client.retryOnConnectionFailure()) {
            return false;
        }
        if (bl && request.body() instanceof UnrepeatableRequestBody) {
            return false;
        }
        if (!this.isRecoverable(iOException, bl)) {
            return false;
        }
        return this.streamAllocation.hasMoreRoutes();
    }

    private boolean isRecoverable(IOException iOException, boolean bl) {
        if (iOException instanceof ProtocolException) {
            return false;
        }
        if (iOException instanceof InterruptedIOException) {
            return iOException instanceof SocketTimeoutException && !bl;
        }
        if (iOException instanceof SSLHandshakeException && iOException.getCause() instanceof CertificateException) {
            return false;
        }
        return !(iOException instanceof SSLPeerUnverifiedException);
    }

    private Request followUpRequest(Response response) throws IOException {
        if (response == null) {
            throw new IllegalStateException();
        }
        Object object = this.streamAllocation.connection();
        object = object != null ? object.route() : null;
        int n2 = response.code();
        String string = response.request().method();
        switch (n2) {
            case 407: {
                Proxy proxy = object != null ? ((Route)object).proxy() : this.client.proxy();
                if (proxy.type() != Proxy.Type.HTTP) {
                    throw new ProtocolException("Received HTTP_PROXY_AUTH (407) code while not using proxy");
                }
                return this.client.proxyAuthenticator().authenticate((Route)object, response);
            }
            case 401: {
                return this.client.authenticator().authenticate((Route)object, response);
            }
            case 307: 
            case 308: {
                if (!string.equals("GET") && !string.equals("HEAD")) {
                    return null;
                }
            }
            case 300: 
            case 301: 
            case 302: 
            case 303: {
                if (!this.client.followRedirects()) {
                    return null;
                }
                object = response.header("Location");
                if (object == null) {
                    return null;
                }
                object = response.request().url().resolve((String)object);
                if (object == null) {
                    return null;
                }
                boolean bl = ((HttpUrl)object).scheme().equals(response.request().url().scheme());
                n2 = bl ? 1 : 0;
                if (!bl && !this.client.followSslRedirects()) {
                    return null;
                }
                Request$Builder request$Builder = response.request().newBuilder();
                if (HttpMethod.permitsRequestBody(string)) {
                    boolean bl2 = HttpMethod.redirectsWithBody(string);
                    if (HttpMethod.redirectsToGet(string)) {
                        request$Builder.method("GET", null);
                    } else {
                        RequestBody requestBody = bl2 ? response.request().body() : null;
                        request$Builder.method(string, requestBody);
                    }
                    if (!bl2) {
                        request$Builder.removeHeader("Transfer-Encoding");
                        request$Builder.removeHeader("Content-Length");
                        request$Builder.removeHeader("Content-Type");
                    }
                }
                if (!this.sameConnection(response, (HttpUrl)object)) {
                    request$Builder.removeHeader("Authorization");
                }
                return request$Builder.url((HttpUrl)object).build();
            }
            case 408: {
                if (response.request().body() instanceof UnrepeatableRequestBody) {
                    return null;
                }
                return response.request();
            }
        }
        return null;
    }

    private boolean sameConnection(Response object, HttpUrl httpUrl) {
        return ((HttpUrl)(object = ((Response)object).request().url())).host().equals(httpUrl.host()) && ((HttpUrl)object).port() == httpUrl.port() && ((HttpUrl)object).scheme().equals(httpUrl.scheme());
    }
}

