/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.okhttp3.internal.http;

import com.zoyi.io.socket.okhttp3.Interceptor;
import com.zoyi.io.socket.okhttp3.Interceptor$Chain;
import com.zoyi.io.socket.okhttp3.Request;
import com.zoyi.io.socket.okhttp3.Response;
import com.zoyi.io.socket.okhttp3.internal.Util;
import com.zoyi.io.socket.okhttp3.internal.connection.StreamAllocation;
import com.zoyi.io.socket.okhttp3.internal.http.HttpCodec;
import com.zoyi.io.socket.okhttp3.internal.http.HttpMethod;
import com.zoyi.io.socket.okhttp3.internal.http.RealInterceptorChain;
import com.zoyi.io.socket.okio.BufferedSink;
import com.zoyi.io.socket.okio.Okio;
import com.zoyi.io.socket.okio.Sink;
import java.io.Closeable;
import java.io.IOException;
import java.net.ProtocolException;

public final class CallServerInterceptor
implements Interceptor {
    private final boolean forWebSocket;

    public CallServerInterceptor(boolean bl) {
        this.forWebSocket = bl;
    }

    @Override
    public final Response intercept(Interceptor$Chain object) throws IOException {
        Closeable closeable;
        HttpCodec httpCodec = ((RealInterceptorChain)object).httpStream();
        StreamAllocation streamAllocation = ((RealInterceptorChain)object).streamAllocation();
        object = object.request();
        long l2 = System.currentTimeMillis();
        httpCodec.writeRequestHeaders((Request)object);
        if (HttpMethod.permitsRequestBody(((Request)object).method()) && ((Request)object).body() != null) {
            closeable = httpCodec.createRequestBody((Request)object, ((Request)object).body().contentLength());
            BufferedSink bufferedSink = Okio.buffer((Sink)closeable);
            ((Request)object).body().writeTo(bufferedSink);
            bufferedSink.close();
        }
        httpCodec.finishRequest();
        closeable = httpCodec.readResponseHeaders().request((Request)object).handshake(streamAllocation.connection().handshake()).sentRequestAtMillis(l2).receivedResponseAtMillis(System.currentTimeMillis()).build();
        int n2 = ((Response)closeable).code();
        closeable = this.forWebSocket && n2 == 101 ? ((Response)closeable).newBuilder().body(Util.EMPTY_RESPONSE).build() : ((Response)closeable).newBuilder().body(httpCodec.openResponseBody((Response)closeable)).build();
        if ("close".equalsIgnoreCase(((Response)closeable).request().header("Connection")) || "close".equalsIgnoreCase(((Response)closeable).header("Connection"))) {
            streamAllocation.noNewStreams();
        }
        if ((n2 == 204 || n2 == 205) && ((Response)closeable).body().contentLength() > 0L) {
            throw new ProtocolException("HTTP " + n2 + " had non-zero Content-Length: " + ((Response)closeable).body().contentLength());
        }
        return closeable;
    }
}

