/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.okhttp3.internal.cache2;

import com.zoyi.io.socket.okhttp3.internal.Util;
import com.zoyi.io.socket.okhttp3.internal.cache2.FileOperator;
import com.zoyi.io.socket.okhttp3.internal.cache2.Relay$RelaySource;
import com.zoyi.io.socket.okio.Buffer;
import com.zoyi.io.socket.okio.ByteString;
import com.zoyi.io.socket.okio.Source;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

final class Relay {
    private static final int SOURCE_UPSTREAM = 1;
    private static final int SOURCE_FILE = 2;
    static final ByteString PREFIX_CLEAN = ByteString.encodeUtf8("OkHttp cache v1\n");
    static final ByteString PREFIX_DIRTY = ByteString.encodeUtf8("OkHttp DIRTY :(\n");
    private static final long FILE_HEADER_SIZE = 32L;
    RandomAccessFile file;
    Thread upstreamReader;
    Source upstream;
    final Buffer upstreamBuffer = new Buffer();
    long upstreamPos;
    boolean complete;
    private final ByteString metadata;
    final Buffer buffer = new Buffer();
    final long bufferMaxSize;
    int sourceCount;

    private Relay(RandomAccessFile randomAccessFile, Source source, long l2, ByteString byteString, long l3) {
        this.file = randomAccessFile;
        this.upstream = source;
        this.complete = source == null;
        this.upstreamPos = l2;
        this.metadata = byteString;
        this.bufferMaxSize = l3;
    }

    public static Relay edit(File object, Source object2, ByteString byteString, long l2) throws IOException {
        object = new RandomAccessFile((File)object, "rw");
        object2 = new Relay((RandomAccessFile)object, (Source)object2, 0L, byteString, l2);
        ((RandomAccessFile)object).setLength(0L);
        super.writeHeader(PREFIX_DIRTY, -1L, -1L);
        return object2;
    }

    public static Relay read(File object) throws IOException {
        object = new RandomAccessFile((File)object, "rw");
        Object object2 = new FileOperator(((RandomAccessFile)object).getChannel());
        Buffer buffer = new Buffer();
        ((FileOperator)object2).read(0L, buffer, 32L);
        ByteString byteString = buffer.readByteString(PREFIX_CLEAN.size());
        if (!byteString.equals(PREFIX_CLEAN)) {
            throw new IOException("unreadable cache file");
        }
        long l2 = buffer.readLong();
        long l3 = buffer.readLong();
        buffer = new Buffer();
        ((FileOperator)object2).read(l2 + 32L, buffer, l3);
        object2 = buffer.readByteString();
        return new Relay((RandomAccessFile)object, null, l2, (ByteString)object2, 0L);
    }

    private void writeHeader(ByteString object, long l2, long l3) throws IOException {
        Buffer buffer = new Buffer();
        buffer.write((ByteString)object);
        buffer.writeLong(l2);
        buffer.writeLong(l3);
        if (buffer.size() != 32L) {
            throw new IllegalArgumentException();
        }
        object = new FileOperator(this.file.getChannel());
        ((FileOperator)object).write(0L, buffer, 32L);
    }

    private void writeMetadata(long l2) throws IOException {
        Buffer buffer = new Buffer();
        buffer.write(this.metadata);
        FileOperator fileOperator = new FileOperator(this.file.getChannel());
        fileOperator.write(l2 + 32L, buffer, this.metadata.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void commit(long l2) throws IOException {
        this.writeMetadata(l2);
        this.file.getChannel().force(false);
        this.writeHeader(PREFIX_CLEAN, l2, this.metadata.size());
        this.file.getChannel().force(false);
        Relay relay = this;
        synchronized (relay) {
            this.complete = true;
        }
        Util.closeQuietly(this.upstream);
        this.upstream = null;
    }

    final boolean isClosed() {
        return this.file == null;
    }

    public final ByteString metadata() {
        return this.metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Source newSource() {
        Relay relay = this;
        synchronized (relay) {
            if (this.file == null) {
                return null;
            }
            ++this.sourceCount;
        }
        return new Relay$RelaySource(this);
    }
}

