/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.okhttp3.internal.cache;

import com.zoyi.io.socket.okhttp3.internal.Util;
import com.zoyi.io.socket.okhttp3.internal.cache.DiskLruCache$1;
import com.zoyi.io.socket.okhttp3.internal.cache.DiskLruCache$2;
import com.zoyi.io.socket.okhttp3.internal.cache.DiskLruCache$3;
import com.zoyi.io.socket.okhttp3.internal.cache.DiskLruCache$Editor;
import com.zoyi.io.socket.okhttp3.internal.cache.DiskLruCache$Entry;
import com.zoyi.io.socket.okhttp3.internal.cache.DiskLruCache$Snapshot;
import com.zoyi.io.socket.okhttp3.internal.io.FileSystem;
import com.zoyi.io.socket.okhttp3.internal.platform.Platform;
import com.zoyi.io.socket.okio.BufferedSink;
import com.zoyi.io.socket.okio.BufferedSource;
import com.zoyi.io.socket.okio.Okio;
import com.zoyi.io.socket.okio.Sink;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Flushable;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DiskLruCache
implements Closeable,
Flushable {
    static final String JOURNAL_FILE = "journal";
    static final String JOURNAL_FILE_TEMP = "journal.tmp";
    static final String JOURNAL_FILE_BACKUP = "journal.bkp";
    static final String MAGIC = "libcore.io.DiskLruCache";
    static final String VERSION_1 = "1";
    static final long ANY_SEQUENCE_NUMBER = -1L;
    static final Pattern LEGAL_KEY_PATTERN = Pattern.compile("[a-z0-9_-]{1,120}");
    private static final String CLEAN = "CLEAN";
    private static final String DIRTY = "DIRTY";
    private static final String REMOVE = "REMOVE";
    private static final String READ = "READ";
    final FileSystem fileSystem;
    final File directory;
    private final File journalFile;
    private final File journalFileTmp;
    private final File journalFileBackup;
    private final int appVersion;
    private long maxSize;
    final int valueCount;
    private long size = 0L;
    BufferedSink journalWriter;
    final LinkedHashMap<String, DiskLruCache$Entry> lruEntries = new LinkedHashMap(0, 0.75f, true);
    int redundantOpCount;
    boolean hasJournalErrors;
    boolean initialized;
    boolean closed;
    boolean mostRecentTrimFailed;
    boolean mostRecentRebuildFailed;
    private long nextSequenceNumber = 0L;
    private final Executor executor;
    private final Runnable cleanupRunnable = new DiskLruCache$1(this);

    DiskLruCache(FileSystem fileSystem, File file, int n2, int n3, long l2, Executor executor) {
        this.fileSystem = fileSystem;
        this.directory = file;
        this.appVersion = n2;
        this.journalFile = new File(file, JOURNAL_FILE);
        this.journalFileTmp = new File(file, JOURNAL_FILE_TEMP);
        this.journalFileBackup = new File(file, JOURNAL_FILE_BACKUP);
        this.valueCount = n3;
        this.maxSize = l2;
        this.executor = executor;
    }

    public final synchronized void initialize() throws IOException {
        assert (Thread.holdsLock(this));
        if (this.initialized) {
            return;
        }
        if (this.fileSystem.exists(this.journalFileBackup)) {
            if (this.fileSystem.exists(this.journalFile)) {
                this.fileSystem.delete(this.journalFileBackup);
            } else {
                this.fileSystem.rename(this.journalFileBackup, this.journalFile);
            }
        }
        if (this.fileSystem.exists(this.journalFile)) {
            try {
                this.readJournal();
                this.processJournal();
                this.initialized = true;
                return;
            }
            catch (IOException iOException) {
                Platform.get().log(5, "DiskLruCache " + this.directory + " is corrupt: " + iOException.getMessage() + ", removing", iOException);
                this.delete();
                this.closed = false;
            }
        }
        this.rebuildJournal();
        this.initialized = true;
    }

    public static DiskLruCache create(FileSystem fileSystem, File file, int n2, int n3, long l2) {
        if (l2 <= 0L) {
            throw new IllegalArgumentException("maxSize <= 0");
        }
        if (n3 <= 0) {
            throw new IllegalArgumentException("valueCount <= 0");
        }
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), Util.threadFactory("OkHttp DiskLruCache", true));
        return new DiskLruCache(fileSystem, file, n2, n3, l2, threadPoolExecutor);
    }

    private void readJournal() throws IOException {
        BufferedSource bufferedSource = Okio.buffer(this.fileSystem.source(this.journalFile));
        try {
            String string = bufferedSource.readUtf8LineStrict();
            String string2 = bufferedSource.readUtf8LineStrict();
            String string3 = bufferedSource.readUtf8LineStrict();
            String string4 = bufferedSource.readUtf8LineStrict();
            String string5 = bufferedSource.readUtf8LineStrict();
            if (!(MAGIC.equals(string) && VERSION_1.equals(string2) && Integer.toString(this.appVersion).equals(string3) && Integer.toString(this.valueCount).equals(string4) && "".equals(string5))) {
                throw new IOException("unexpected journal header: [" + string + ", " + string2 + ", " + string4 + ", " + string5 + "]");
            }
            int n2 = 0;
            try {
                while (true) {
                    this.readJournalLine(bufferedSource.readUtf8LineStrict());
                    ++n2;
                }
            }
            catch (EOFException eOFException) {
                this.redundantOpCount = n2 - this.lruEntries.size();
                if (!bufferedSource.exhausted()) {
                    this.rebuildJournal();
                } else {
                    this.journalWriter = this.newJournalWriter();
                }
                return;
            }
        }
        finally {
            Util.closeQuietly(bufferedSource);
        }
    }

    private BufferedSink newJournalWriter() throws FileNotFoundException {
        Sink sink = this.fileSystem.appendingSink(this.journalFile);
        sink = new DiskLruCache$2(this, sink);
        return Okio.buffer(sink);
    }

    private void readJournalLine(String stringArray) throws IOException {
        DiskLruCache$Entry diskLruCache$Entry;
        String string;
        int n2 = stringArray.indexOf(32);
        if (n2 == -1) {
            throw new IOException("unexpected journal line: " + (String)stringArray);
        }
        int n3 = n2 + 1;
        int n4 = stringArray.indexOf(32, n3);
        if (n4 == -1) {
            string = stringArray.substring(n3);
            if (n2 == 6 && stringArray.startsWith(REMOVE)) {
                this.lruEntries.remove(string);
                return;
            }
        } else {
            string = stringArray.substring(n3, n4);
        }
        if ((diskLruCache$Entry = this.lruEntries.get(string)) == null) {
            diskLruCache$Entry = new DiskLruCache$Entry(this, string);
            this.lruEntries.put(string, diskLruCache$Entry);
        }
        if (n4 != -1 && n2 == 5 && stringArray.startsWith(CLEAN)) {
            stringArray = stringArray.substring(n4 + 1).split(" ");
            diskLruCache$Entry.readable = true;
            diskLruCache$Entry.currentEditor = null;
            diskLruCache$Entry.setLengths(stringArray);
            return;
        }
        if (n4 == -1 && n2 == 5 && stringArray.startsWith(DIRTY)) {
            diskLruCache$Entry.currentEditor = new DiskLruCache$Editor(this, diskLruCache$Entry);
            return;
        }
        if (n4 != -1 || n2 != 4 || !stringArray.startsWith(READ)) {
            throw new IOException("unexpected journal line: " + (String)stringArray);
        }
    }

    private void processJournal() throws IOException {
        this.fileSystem.delete(this.journalFileTmp);
        Iterator<DiskLruCache$Entry> iterator = this.lruEntries.values().iterator();
        while (iterator.hasNext()) {
            int n2;
            DiskLruCache$Entry diskLruCache$Entry = iterator.next();
            if (diskLruCache$Entry.currentEditor == null) {
                for (n2 = 0; n2 < this.valueCount; ++n2) {
                    this.size += diskLruCache$Entry.lengths[n2];
                }
                continue;
            }
            diskLruCache$Entry.currentEditor = null;
            for (n2 = 0; n2 < this.valueCount; ++n2) {
                this.fileSystem.delete(diskLruCache$Entry.cleanFiles[n2]);
                this.fileSystem.delete(diskLruCache$Entry.dirtyFiles[n2]);
            }
            iterator.remove();
        }
    }

    final synchronized void rebuildJournal() throws IOException {
        if (this.journalWriter != null) {
            this.journalWriter.close();
        }
        try (BufferedSink bufferedSink = Okio.buffer(this.fileSystem.sink(this.journalFileTmp));){
            bufferedSink.writeUtf8(MAGIC).writeByte(10);
            bufferedSink.writeUtf8(VERSION_1).writeByte(10);
            bufferedSink.writeDecimalLong(this.appVersion).writeByte(10);
            bufferedSink.writeDecimalLong(this.valueCount).writeByte(10);
            bufferedSink.writeByte(10);
            for (DiskLruCache$Entry diskLruCache$Entry : this.lruEntries.values()) {
                if (diskLruCache$Entry.currentEditor != null) {
                    bufferedSink.writeUtf8(DIRTY).writeByte(32);
                    bufferedSink.writeUtf8(diskLruCache$Entry.key);
                    bufferedSink.writeByte(10);
                    continue;
                }
                bufferedSink.writeUtf8(CLEAN).writeByte(32);
                bufferedSink.writeUtf8(diskLruCache$Entry.key);
                diskLruCache$Entry.writeLengths(bufferedSink);
                bufferedSink.writeByte(10);
            }
        }
        if (this.fileSystem.exists(this.journalFile)) {
            this.fileSystem.rename(this.journalFile, this.journalFileBackup);
        }
        this.fileSystem.rename(this.journalFileTmp, this.journalFile);
        this.fileSystem.delete(this.journalFileBackup);
        this.journalWriter = this.newJournalWriter();
        this.hasJournalErrors = false;
        this.mostRecentRebuildFailed = false;
    }

    public final synchronized DiskLruCache$Snapshot get(String string) throws IOException {
        this.initialize();
        this.checkNotClosed();
        this.validateKey(string);
        Object object = this.lruEntries.get(string);
        if (object == null || !((DiskLruCache$Entry)object).readable) {
            return null;
        }
        if ((object = ((DiskLruCache$Entry)object).snapshot()) == null) {
            return null;
        }
        ++this.redundantOpCount;
        this.journalWriter.writeUtf8(READ).writeByte(32).writeUtf8(string).writeByte(10);
        if (this.journalRebuildRequired()) {
            this.executor.execute(this.cleanupRunnable);
        }
        return object;
    }

    public final DiskLruCache$Editor edit(String string) throws IOException {
        return this.edit(string, -1L);
    }

    final synchronized DiskLruCache$Editor edit(String object, long l2) throws IOException {
        this.initialize();
        this.checkNotClosed();
        this.validateKey((String)object);
        DiskLruCache$Entry diskLruCache$Entry = this.lruEntries.get(object);
        if (l2 != -1L && (diskLruCache$Entry == null || diskLruCache$Entry.sequenceNumber != l2)) {
            return null;
        }
        if (diskLruCache$Entry != null && diskLruCache$Entry.currentEditor != null) {
            return null;
        }
        if (this.mostRecentTrimFailed || this.mostRecentRebuildFailed) {
            this.executor.execute(this.cleanupRunnable);
            return null;
        }
        this.journalWriter.writeUtf8(DIRTY).writeByte(32).writeUtf8((String)object).writeByte(10);
        this.journalWriter.flush();
        if (this.hasJournalErrors) {
            return null;
        }
        if (diskLruCache$Entry == null) {
            diskLruCache$Entry = new DiskLruCache$Entry(this, (String)object);
            this.lruEntries.put((String)object, diskLruCache$Entry);
        }
        diskLruCache$Entry.currentEditor = object = new DiskLruCache$Editor(this, diskLruCache$Entry);
        return object;
    }

    public final File getDirectory() {
        return this.directory;
    }

    public final synchronized long getMaxSize() {
        return this.maxSize;
    }

    public final synchronized void setMaxSize(long l2) {
        this.maxSize = l2;
        if (this.initialized) {
            this.executor.execute(this.cleanupRunnable);
        }
    }

    public final synchronized long size() throws IOException {
        this.initialize();
        return this.size;
    }

    final synchronized void completeEdit(DiskLruCache$Editor object, boolean bl) throws IOException {
        int n2;
        DiskLruCache$Entry diskLruCache$Entry = ((DiskLruCache$Editor)object).entry;
        if (diskLruCache$Entry.currentEditor != object) {
            throw new IllegalStateException();
        }
        if (bl && !diskLruCache$Entry.readable) {
            for (n2 = 0; n2 < this.valueCount; ++n2) {
                if (!((DiskLruCache$Editor)object).written[n2]) {
                    ((DiskLruCache$Editor)object).abort();
                    throw new IllegalStateException("Newly created entry didn't create value for index " + n2);
                }
                if (this.fileSystem.exists(diskLruCache$Entry.dirtyFiles[n2])) continue;
                ((DiskLruCache$Editor)object).abort();
                return;
            }
        }
        for (n2 = 0; n2 < this.valueCount; ++n2) {
            object = diskLruCache$Entry.dirtyFiles[n2];
            if (bl) {
                long l2;
                if (!this.fileSystem.exists((File)object)) continue;
                File file = diskLruCache$Entry.cleanFiles[n2];
                this.fileSystem.rename((File)object, file);
                long l3 = diskLruCache$Entry.lengths[n2];
                diskLruCache$Entry.lengths[n2] = l2 = this.fileSystem.size(file);
                this.size = this.size - l3 + l2;
                continue;
            }
            this.fileSystem.delete((File)object);
        }
        ++this.redundantOpCount;
        diskLruCache$Entry.currentEditor = null;
        if (diskLruCache$Entry.readable | bl) {
            diskLruCache$Entry.readable = true;
            this.journalWriter.writeUtf8(CLEAN).writeByte(32);
            this.journalWriter.writeUtf8(diskLruCache$Entry.key);
            diskLruCache$Entry.writeLengths(this.journalWriter);
            this.journalWriter.writeByte(10);
            if (bl) {
                diskLruCache$Entry.sequenceNumber = this.nextSequenceNumber++;
            }
        } else {
            this.lruEntries.remove(diskLruCache$Entry.key);
            this.journalWriter.writeUtf8(REMOVE).writeByte(32);
            this.journalWriter.writeUtf8(diskLruCache$Entry.key);
            this.journalWriter.writeByte(10);
        }
        this.journalWriter.flush();
        if (this.size > this.maxSize || this.journalRebuildRequired()) {
            this.executor.execute(this.cleanupRunnable);
        }
    }

    final boolean journalRebuildRequired() {
        return this.redundantOpCount >= 2000 && this.redundantOpCount >= this.lruEntries.size();
    }

    public final synchronized boolean remove(String object) throws IOException {
        this.initialize();
        this.checkNotClosed();
        this.validateKey((String)object);
        object = this.lruEntries.get(object);
        if (object == null) {
            return false;
        }
        boolean bl = this.removeEntry((DiskLruCache$Entry)object);
        if (bl && this.size <= this.maxSize) {
            this.mostRecentTrimFailed = false;
        }
        return bl;
    }

    final boolean removeEntry(DiskLruCache$Entry diskLruCache$Entry) throws IOException {
        if (diskLruCache$Entry.currentEditor != null) {
            diskLruCache$Entry.currentEditor.detach();
        }
        for (int i2 = 0; i2 < this.valueCount; ++i2) {
            this.fileSystem.delete(diskLruCache$Entry.cleanFiles[i2]);
            this.size -= diskLruCache$Entry.lengths[i2];
            diskLruCache$Entry.lengths[i2] = 0L;
        }
        ++this.redundantOpCount;
        this.journalWriter.writeUtf8(REMOVE).writeByte(32).writeUtf8(diskLruCache$Entry.key).writeByte(10);
        this.lruEntries.remove(diskLruCache$Entry.key);
        if (this.journalRebuildRequired()) {
            this.executor.execute(this.cleanupRunnable);
        }
        return true;
    }

    public final synchronized boolean isClosed() {
        return this.closed;
    }

    private synchronized void checkNotClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException("cache is closed");
        }
    }

    @Override
    public final synchronized void flush() throws IOException {
        if (!this.initialized) {
            return;
        }
        this.checkNotClosed();
        this.trimToSize();
        this.journalWriter.flush();
    }

    @Override
    public final synchronized void close() throws IOException {
        if (!this.initialized || this.closed) {
            this.closed = true;
            return;
        }
        for (DiskLruCache$Entry diskLruCache$Entry : this.lruEntries.values().toArray(new DiskLruCache$Entry[this.lruEntries.size()])) {
            if (diskLruCache$Entry.currentEditor == null) continue;
            diskLruCache$Entry.currentEditor.abort();
        }
        this.trimToSize();
        this.journalWriter.close();
        this.journalWriter = null;
        this.closed = true;
    }

    final void trimToSize() throws IOException {
        while (this.size > this.maxSize) {
            DiskLruCache$Entry diskLruCache$Entry = this.lruEntries.values().iterator().next();
            this.removeEntry(diskLruCache$Entry);
        }
        this.mostRecentTrimFailed = false;
    }

    public final void delete() throws IOException {
        this.close();
        this.fileSystem.deleteContents(this.directory);
    }

    public final synchronized void evictAll() throws IOException {
        this.initialize();
        for (DiskLruCache$Entry diskLruCache$Entry : this.lruEntries.values().toArray(new DiskLruCache$Entry[this.lruEntries.size()])) {
            this.removeEntry(diskLruCache$Entry);
        }
        this.mostRecentTrimFailed = false;
    }

    private void validateKey(String string) {
        Matcher matcher = LEGAL_KEY_PATTERN.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("keys must match regex [a-z0-9_-]{1,120}: \"" + string + "\"");
        }
    }

    public final synchronized Iterator<DiskLruCache$Snapshot> snapshots() throws IOException {
        this.initialize();
        return new DiskLruCache$3(this);
    }
}

