/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.okhttp3.internal.cache;

import com.zoyi.io.socket.okhttp3.Headers;
import com.zoyi.io.socket.okhttp3.Headers$Builder;
import com.zoyi.io.socket.okhttp3.Interceptor;
import com.zoyi.io.socket.okhttp3.Interceptor$Chain;
import com.zoyi.io.socket.okhttp3.Protocol;
import com.zoyi.io.socket.okhttp3.Request;
import com.zoyi.io.socket.okhttp3.Response;
import com.zoyi.io.socket.okhttp3.Response$Builder;
import com.zoyi.io.socket.okhttp3.internal.Internal;
import com.zoyi.io.socket.okhttp3.internal.Util;
import com.zoyi.io.socket.okhttp3.internal.cache.CacheInterceptor$1;
import com.zoyi.io.socket.okhttp3.internal.cache.CacheRequest;
import com.zoyi.io.socket.okhttp3.internal.cache.CacheStrategy;
import com.zoyi.io.socket.okhttp3.internal.cache.CacheStrategy$Factory;
import com.zoyi.io.socket.okhttp3.internal.cache.InternalCache;
import com.zoyi.io.socket.okhttp3.internal.http.HttpHeaders;
import com.zoyi.io.socket.okhttp3.internal.http.HttpMethod;
import com.zoyi.io.socket.okhttp3.internal.http.RealResponseBody;
import com.zoyi.io.socket.okio.BufferedSink;
import com.zoyi.io.socket.okio.BufferedSource;
import com.zoyi.io.socket.okio.Okio;
import com.zoyi.io.socket.okio.Sink;
import com.zoyi.io.socket.okio.Source;
import java.io.IOException;

public final class CacheInterceptor
implements Interceptor {
    final InternalCache cache;

    public CacheInterceptor(InternalCache internalCache) {
        this.cache = internalCache;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final Response intercept(Interceptor$Chain object) throws IOException {
        Response response;
        Object object2;
        block8: {
            Response response2 = this.cache != null ? this.cache.get(object.request()) : null;
            long l2 = System.currentTimeMillis();
            object2 = new CacheStrategy$Factory(l2, object.request(), response2).get();
            Request request = ((CacheStrategy)object2).networkRequest;
            response = ((CacheStrategy)object2).cacheResponse;
            if (this.cache != null) {
                this.cache.trackResponse((CacheStrategy)object2);
            }
            if (response2 != null && response == null) {
                Util.closeQuietly(response2.body());
            }
            if (request == null && response == null) {
                return new Response$Builder().request(object.request()).protocol(Protocol.HTTP_1_1).code(504).message("Unsatisfiable Request (only-if-cached)").body(Util.EMPTY_RESPONSE).sentRequestAtMillis(-1L).receivedResponseAtMillis(System.currentTimeMillis()).build();
            }
            if (request == null) {
                return response.newBuilder().cacheResponse(CacheInterceptor.stripBody(response)).build();
            }
            try {
                object = object.proceed(request);
                if (object != null || response2 == null) break block8;
            }
            catch (Throwable throwable) {
                if (response2 == null) throw throwable;
                Util.closeQuietly(response2.body());
                throw throwable;
            }
            Util.closeQuietly(response2.body());
        }
        if (response != null) {
            if (((Response)object).code() == 304) {
                object2 = response.newBuilder().headers(CacheInterceptor.combine(response.headers(), ((Response)object).headers())).sentRequestAtMillis(((Response)object).sentRequestAtMillis()).receivedResponseAtMillis(((Response)object).receivedResponseAtMillis()).cacheResponse(CacheInterceptor.stripBody(response)).networkResponse(CacheInterceptor.stripBody((Response)object)).build();
                ((Response)object).body().close();
                this.cache.trackConditionalCacheHit();
                this.cache.update(response, (Response)object2);
                return object2;
            }
            Util.closeQuietly(response.body());
        }
        if (!HttpHeaders.hasBody((Response)(object2 = ((Response)object).newBuilder().cacheResponse(CacheInterceptor.stripBody(response)).networkResponse(CacheInterceptor.stripBody((Response)object)).build()))) return object2;
        object = this.maybeCache((Response)object2, ((Response)object).request(), this.cache);
        return this.cacheWritingResponse((CacheRequest)object, (Response)object2);
    }

    private static Response stripBody(Response response) {
        if (response != null && response.body() != null) {
            return response.newBuilder().body(null).build();
        }
        return response;
    }

    private CacheRequest maybeCache(Response response, Request request, InternalCache internalCache) throws IOException {
        if (internalCache == null) {
            return null;
        }
        if (!CacheStrategy.isCacheable(response, request)) {
            if (HttpMethod.invalidatesCache(request.method())) {
                try {
                    internalCache.remove(request);
                }
                catch (IOException iOException) {}
            }
            return null;
        }
        return internalCache.put(response);
    }

    private Response cacheWritingResponse(CacheRequest object, Response response) throws IOException {
        if (object == null) {
            return response;
        }
        Sink sink = object.body();
        if (sink == null) {
            return response;
        }
        BufferedSource bufferedSource = response.body().source();
        sink = Okio.buffer(sink);
        object = new CacheInterceptor$1(this, bufferedSource, (CacheRequest)object, (BufferedSink)sink);
        return response.newBuilder().body(new RealResponseBody(response.headers(), Okio.buffer((Source)object))).build();
    }

    private static Headers combine(Headers headers, Headers headers2) {
        String string;
        int n2;
        Headers$Builder headers$Builder = new Headers$Builder();
        int n3 = headers.size();
        for (n2 = 0; n2 < n3; ++n2) {
            string = headers.name(n2);
            String string2 = headers.value(n2);
            if ("Warning".equalsIgnoreCase(string) && string2.startsWith("1") || CacheInterceptor.isEndToEnd(string) && headers2.get(string) != null) continue;
            Internal.instance.addLenient(headers$Builder, string, string2);
        }
        n3 = headers2.size();
        for (n2 = 0; n2 < n3; ++n2) {
            string = headers2.name(n2);
            if ("Content-Length".equalsIgnoreCase(string) || !CacheInterceptor.isEndToEnd(string)) continue;
            Internal.instance.addLenient(headers$Builder, string, headers2.value(n2));
        }
        return headers$Builder.build();
    }

    static boolean isEndToEnd(String string) {
        return !"Connection".equalsIgnoreCase(string) && !"Keep-Alive".equalsIgnoreCase(string) && !"Proxy-Authenticate".equalsIgnoreCase(string) && !"Proxy-Authorization".equalsIgnoreCase(string) && !"TE".equalsIgnoreCase(string) && !"Trailers".equalsIgnoreCase(string) && !"Transfer-Encoding".equalsIgnoreCase(string) && !"Upgrade".equalsIgnoreCase(string);
    }
}

