/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.okhttp3;

import com.zoyi.io.socket.okhttp3.Handshake;
import com.zoyi.io.socket.okhttp3.Headers;
import com.zoyi.io.socket.okhttp3.Headers$Builder;
import com.zoyi.io.socket.okhttp3.Protocol;
import com.zoyi.io.socket.okhttp3.Request;
import com.zoyi.io.socket.okhttp3.Response;
import com.zoyi.io.socket.okhttp3.ResponseBody;

public class Response$Builder {
    Request request;
    Protocol protocol;
    int code = -1;
    String message;
    Handshake handshake;
    Headers$Builder headers;
    ResponseBody body;
    Response networkResponse;
    Response cacheResponse;
    Response priorResponse;
    long sentRequestAtMillis;
    long receivedResponseAtMillis;

    public Response$Builder() {
        this.headers = new Headers$Builder();
    }

    Response$Builder(Response response) {
        this.request = response.request;
        this.protocol = response.protocol;
        this.code = response.code;
        this.message = response.message;
        this.handshake = response.handshake;
        this.headers = response.headers.newBuilder();
        this.body = response.body;
        this.networkResponse = response.networkResponse;
        this.cacheResponse = response.cacheResponse;
        this.priorResponse = response.priorResponse;
        this.sentRequestAtMillis = response.sentRequestAtMillis;
        this.receivedResponseAtMillis = response.receivedResponseAtMillis;
    }

    public Response$Builder request(Request request) {
        this.request = request;
        return this;
    }

    public Response$Builder protocol(Protocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public Response$Builder code(int n2) {
        this.code = n2;
        return this;
    }

    public Response$Builder message(String string) {
        this.message = string;
        return this;
    }

    public Response$Builder handshake(Handshake handshake) {
        this.handshake = handshake;
        return this;
    }

    public Response$Builder header(String string, String string2) {
        this.headers.set(string, string2);
        return this;
    }

    public Response$Builder addHeader(String string, String string2) {
        this.headers.add(string, string2);
        return this;
    }

    public Response$Builder removeHeader(String string) {
        this.headers.removeAll(string);
        return this;
    }

    public Response$Builder headers(Headers headers) {
        this.headers = headers.newBuilder();
        return this;
    }

    public Response$Builder body(ResponseBody responseBody) {
        this.body = responseBody;
        return this;
    }

    public Response$Builder networkResponse(Response response) {
        if (response != null) {
            this.checkSupportResponse("networkResponse", response);
        }
        this.networkResponse = response;
        return this;
    }

    public Response$Builder cacheResponse(Response response) {
        if (response != null) {
            this.checkSupportResponse("cacheResponse", response);
        }
        this.cacheResponse = response;
        return this;
    }

    private void checkSupportResponse(String string, Response response) {
        if (response.body != null) {
            throw new IllegalArgumentException(string + ".body != null");
        }
        if (response.networkResponse != null) {
            throw new IllegalArgumentException(string + ".networkResponse != null");
        }
        if (response.cacheResponse != null) {
            throw new IllegalArgumentException(string + ".cacheResponse != null");
        }
        if (response.priorResponse != null) {
            throw new IllegalArgumentException(string + ".priorResponse != null");
        }
    }

    public Response$Builder priorResponse(Response response) {
        if (response != null) {
            this.checkPriorResponse(response);
        }
        this.priorResponse = response;
        return this;
    }

    private void checkPriorResponse(Response response) {
        if (response.body != null) {
            throw new IllegalArgumentException("priorResponse.body != null");
        }
    }

    public Response$Builder sentRequestAtMillis(long l2) {
        this.sentRequestAtMillis = l2;
        return this;
    }

    public Response$Builder receivedResponseAtMillis(long l2) {
        this.receivedResponseAtMillis = l2;
        return this;
    }

    public Response build() {
        if (this.request == null) {
            throw new IllegalStateException("request == null");
        }
        if (this.protocol == null) {
            throw new IllegalStateException("protocol == null");
        }
        if (this.code < 0) {
            throw new IllegalStateException("code < 0: " + this.code);
        }
        return new Response(this);
    }
}

