/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.okhttp3;

import com.zoyi.io.socket.okhttp3.CacheControl;
import com.zoyi.io.socket.okhttp3.Headers;
import com.zoyi.io.socket.okhttp3.Headers$Builder;
import com.zoyi.io.socket.okhttp3.HttpUrl;
import com.zoyi.io.socket.okhttp3.Request;
import com.zoyi.io.socket.okhttp3.RequestBody;
import com.zoyi.io.socket.okhttp3.internal.Util;
import com.zoyi.io.socket.okhttp3.internal.http.HttpMethod;
import java.net.URL;

public class Request$Builder {
    HttpUrl url;
    String method;
    Headers$Builder headers;
    RequestBody body;
    Object tag;

    public Request$Builder() {
        this.method = "GET";
        this.headers = new Headers$Builder();
    }

    Request$Builder(Request request) {
        this.url = request.url;
        this.method = request.method;
        this.body = request.body;
        this.tag = request.tag;
        this.headers = request.headers.newBuilder();
    }

    public Request$Builder url(HttpUrl httpUrl) {
        if (httpUrl == null) {
            throw new NullPointerException("url == null");
        }
        this.url = httpUrl;
        return this;
    }

    public Request$Builder url(String string) {
        if (string == null) {
            throw new NullPointerException("url == null");
        }
        if (string.regionMatches(true, 0, "ws:", 0, 3)) {
            string = "http:" + string.substring(3);
        } else if (string.regionMatches(true, 0, "wss:", 0, 4)) {
            string = "https:" + string.substring(4);
        }
        HttpUrl httpUrl = HttpUrl.parse(string);
        if (httpUrl == null) {
            throw new IllegalArgumentException("unexpected url: " + string);
        }
        return this.url(httpUrl);
    }

    public Request$Builder url(URL uRL) {
        if (uRL == null) {
            throw new NullPointerException("url == null");
        }
        HttpUrl httpUrl = HttpUrl.get(uRL);
        if (httpUrl == null) {
            throw new IllegalArgumentException("unexpected url: " + uRL);
        }
        return this.url(httpUrl);
    }

    public Request$Builder header(String string, String string2) {
        this.headers.set(string, string2);
        return this;
    }

    public Request$Builder addHeader(String string, String string2) {
        this.headers.add(string, string2);
        return this;
    }

    public Request$Builder removeHeader(String string) {
        this.headers.removeAll(string);
        return this;
    }

    public Request$Builder headers(Headers headers) {
        this.headers = headers.newBuilder();
        return this;
    }

    public Request$Builder cacheControl(CacheControl object) {
        if (((String)(object = ((CacheControl)object).toString())).isEmpty()) {
            return this.removeHeader("Cache-Control");
        }
        return this.header("Cache-Control", (String)object);
    }

    public Request$Builder get() {
        return this.method("GET", null);
    }

    public Request$Builder head() {
        return this.method("HEAD", null);
    }

    public Request$Builder post(RequestBody requestBody) {
        return this.method("POST", requestBody);
    }

    public Request$Builder delete(RequestBody requestBody) {
        return this.method("DELETE", requestBody);
    }

    public Request$Builder delete() {
        return this.delete(Util.EMPTY_REQUEST);
    }

    public Request$Builder put(RequestBody requestBody) {
        return this.method("PUT", requestBody);
    }

    public Request$Builder patch(RequestBody requestBody) {
        return this.method("PATCH", requestBody);
    }

    public Request$Builder method(String string, RequestBody requestBody) {
        if (string == null) {
            throw new NullPointerException("method == null");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("method.length() == 0");
        }
        if (requestBody != null && !HttpMethod.permitsRequestBody(string)) {
            throw new IllegalArgumentException("method " + string + " must not have a request body.");
        }
        if (requestBody == null && HttpMethod.requiresRequestBody(string)) {
            throw new IllegalArgumentException("method " + string + " must have a request body.");
        }
        this.method = string;
        this.body = requestBody;
        return this;
    }

    public Request$Builder tag(Object object) {
        this.tag = object;
        return this;
    }

    public Request build() {
        if (this.url == null) {
            throw new IllegalStateException("url == null");
        }
        return new Request(this);
    }
}

