/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.okhttp3;

import com.zoyi.io.socket.okhttp3.Authenticator;
import com.zoyi.io.socket.okhttp3.Cache;
import com.zoyi.io.socket.okhttp3.Call;
import com.zoyi.io.socket.okhttp3.Call$Factory;
import com.zoyi.io.socket.okhttp3.CertificatePinner;
import com.zoyi.io.socket.okhttp3.ConnectionPool;
import com.zoyi.io.socket.okhttp3.ConnectionSpec;
import com.zoyi.io.socket.okhttp3.CookieJar;
import com.zoyi.io.socket.okhttp3.Dispatcher;
import com.zoyi.io.socket.okhttp3.Dns;
import com.zoyi.io.socket.okhttp3.Interceptor;
import com.zoyi.io.socket.okhttp3.OkHttpClient$1;
import com.zoyi.io.socket.okhttp3.OkHttpClient$Builder;
import com.zoyi.io.socket.okhttp3.Protocol;
import com.zoyi.io.socket.okhttp3.RealCall;
import com.zoyi.io.socket.okhttp3.Request;
import com.zoyi.io.socket.okhttp3.WebSocket;
import com.zoyi.io.socket.okhttp3.WebSocket$Factory;
import com.zoyi.io.socket.okhttp3.WebSocketListener;
import com.zoyi.io.socket.okhttp3.internal.Internal;
import com.zoyi.io.socket.okhttp3.internal.Util;
import com.zoyi.io.socket.okhttp3.internal.cache.InternalCache;
import com.zoyi.io.socket.okhttp3.internal.tls.CertificateChainCleaner;
import com.zoyi.io.socket.okhttp3.internal.ws.RealWebSocket;
import java.net.Proxy;
import java.net.ProxySelector;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.List;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class OkHttpClient
implements Call$Factory,
WebSocket$Factory,
Cloneable {
    static final List<Protocol> DEFAULT_PROTOCOLS = Util.immutableList(Protocol.HTTP_2, Protocol.HTTP_1_1);
    static final List<ConnectionSpec> DEFAULT_CONNECTION_SPECS = Util.immutableList(ConnectionSpec.MODERN_TLS, ConnectionSpec.COMPATIBLE_TLS, ConnectionSpec.CLEARTEXT);
    final Dispatcher dispatcher;
    final Proxy proxy;
    final List<Protocol> protocols;
    final List<ConnectionSpec> connectionSpecs;
    final List<Interceptor> interceptors;
    final List<Interceptor> networkInterceptors;
    final ProxySelector proxySelector;
    final CookieJar cookieJar;
    final Cache cache;
    final InternalCache internalCache;
    final SocketFactory socketFactory;
    final SSLSocketFactory sslSocketFactory;
    final CertificateChainCleaner certificateChainCleaner;
    final HostnameVerifier hostnameVerifier;
    final CertificatePinner certificatePinner;
    final Authenticator proxyAuthenticator;
    final Authenticator authenticator;
    final ConnectionPool connectionPool;
    final Dns dns;
    final boolean followSslRedirects;
    final boolean followRedirects;
    final boolean retryOnConnectionFailure;
    final int connectTimeout;
    final int readTimeout;
    final int writeTimeout;
    final int pingInterval;

    public OkHttpClient() {
        this(new OkHttpClient$Builder());
    }

    OkHttpClient(OkHttpClient$Builder okHttpClient$Builder) {
        this.dispatcher = okHttpClient$Builder.dispatcher;
        this.proxy = okHttpClient$Builder.proxy;
        this.protocols = okHttpClient$Builder.protocols;
        this.connectionSpecs = okHttpClient$Builder.connectionSpecs;
        this.interceptors = Util.immutableList(okHttpClient$Builder.interceptors);
        this.networkInterceptors = Util.immutableList(okHttpClient$Builder.networkInterceptors);
        this.proxySelector = okHttpClient$Builder.proxySelector;
        this.cookieJar = okHttpClient$Builder.cookieJar;
        this.cache = okHttpClient$Builder.cache;
        this.internalCache = okHttpClient$Builder.internalCache;
        this.socketFactory = okHttpClient$Builder.socketFactory;
        boolean bl = false;
        for (ConnectionSpec connectionSpec : this.connectionSpecs) {
            bl = bl || connectionSpec.isTls();
        }
        if (okHttpClient$Builder.sslSocketFactory != null || !bl) {
            this.sslSocketFactory = okHttpClient$Builder.sslSocketFactory;
            this.certificateChainCleaner = okHttpClient$Builder.certificateChainCleaner;
        } else {
            X509TrustManager x509TrustManager = this.systemDefaultTrustManager();
            this.sslSocketFactory = this.systemDefaultSslSocketFactory(x509TrustManager);
            this.certificateChainCleaner = CertificateChainCleaner.get(x509TrustManager);
        }
        this.hostnameVerifier = okHttpClient$Builder.hostnameVerifier;
        this.certificatePinner = okHttpClient$Builder.certificatePinner.withCertificateChainCleaner(this.certificateChainCleaner);
        this.proxyAuthenticator = okHttpClient$Builder.proxyAuthenticator;
        this.authenticator = okHttpClient$Builder.authenticator;
        this.connectionPool = okHttpClient$Builder.connectionPool;
        this.dns = okHttpClient$Builder.dns;
        this.followSslRedirects = okHttpClient$Builder.followSslRedirects;
        this.followRedirects = okHttpClient$Builder.followRedirects;
        this.retryOnConnectionFailure = okHttpClient$Builder.retryOnConnectionFailure;
        this.connectTimeout = okHttpClient$Builder.connectTimeout;
        this.readTimeout = okHttpClient$Builder.readTimeout;
        this.writeTimeout = okHttpClient$Builder.writeTimeout;
        this.pingInterval = okHttpClient$Builder.pingInterval;
    }

    private X509TrustManager systemDefaultTrustManager() {
        try {
            Object[] objectArray = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            objectArray.init((KeyStore)null);
            objectArray = objectArray.getTrustManagers();
            if (objectArray.length != 1 || !(objectArray[0] instanceof X509TrustManager)) {
                throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(objectArray));
            }
            return (X509TrustManager)objectArray[0];
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new AssertionError();
        }
    }

    private SSLSocketFactory systemDefaultSslSocketFactory(X509TrustManager x509TrustManager) {
        try {
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            sSLContext.init(null, new TrustManager[]{x509TrustManager}, null);
            return sSLContext.getSocketFactory();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new AssertionError();
        }
    }

    public int connectTimeoutMillis() {
        return this.connectTimeout;
    }

    public int readTimeoutMillis() {
        return this.readTimeout;
    }

    public int writeTimeoutMillis() {
        return this.writeTimeout;
    }

    public int pingIntervalMillis() {
        return this.pingInterval;
    }

    public Proxy proxy() {
        return this.proxy;
    }

    public ProxySelector proxySelector() {
        return this.proxySelector;
    }

    public CookieJar cookieJar() {
        return this.cookieJar;
    }

    public Cache cache() {
        return this.cache;
    }

    InternalCache internalCache() {
        if (this.cache != null) {
            return this.cache.internalCache;
        }
        return this.internalCache;
    }

    public Dns dns() {
        return this.dns;
    }

    public SocketFactory socketFactory() {
        return this.socketFactory;
    }

    public SSLSocketFactory sslSocketFactory() {
        return this.sslSocketFactory;
    }

    public HostnameVerifier hostnameVerifier() {
        return this.hostnameVerifier;
    }

    public CertificatePinner certificatePinner() {
        return this.certificatePinner;
    }

    public Authenticator authenticator() {
        return this.authenticator;
    }

    public Authenticator proxyAuthenticator() {
        return this.proxyAuthenticator;
    }

    public ConnectionPool connectionPool() {
        return this.connectionPool;
    }

    public boolean followSslRedirects() {
        return this.followSslRedirects;
    }

    public boolean followRedirects() {
        return this.followRedirects;
    }

    public boolean retryOnConnectionFailure() {
        return this.retryOnConnectionFailure;
    }

    public Dispatcher dispatcher() {
        return this.dispatcher;
    }

    public List<Protocol> protocols() {
        return this.protocols;
    }

    public List<ConnectionSpec> connectionSpecs() {
        return this.connectionSpecs;
    }

    public List<Interceptor> interceptors() {
        return this.interceptors;
    }

    public List<Interceptor> networkInterceptors() {
        return this.networkInterceptors;
    }

    @Override
    public Call newCall(Request request) {
        return new RealCall(this, request, false);
    }

    @Override
    public WebSocket newWebSocket(Request object, WebSocketListener webSocketListener) {
        object = new RealWebSocket((Request)object, webSocketListener, new SecureRandom());
        ((RealWebSocket)object).connect(this);
        return object;
    }

    public OkHttpClient$Builder newBuilder() {
        return new OkHttpClient$Builder(this);
    }

    static {
        Internal.instance = new OkHttpClient$1();
    }
}

