/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.okhttp3;

import com.zoyi.io.socket.okhttp3.Call;
import com.zoyi.io.socket.okhttp3.RealCall;
import com.zoyi.io.socket.okhttp3.RealCall$AsyncCall;
import com.zoyi.io.socket.okhttp3.internal.Util;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class Dispatcher {
    private int maxRequests = 64;
    private int maxRequestsPerHost = 5;
    private Runnable idleCallback;
    private ExecutorService executorService;
    private final Deque<RealCall$AsyncCall> readyAsyncCalls = new ArrayDeque<RealCall$AsyncCall>();
    private final Deque<RealCall$AsyncCall> runningAsyncCalls = new ArrayDeque<RealCall$AsyncCall>();
    private final Deque<RealCall> runningSyncCalls = new ArrayDeque<RealCall>();

    public Dispatcher(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public Dispatcher() {
    }

    public final synchronized ExecutorService executorService() {
        if (this.executorService == null) {
            this.executorService = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Util.threadFactory("OkHttp Dispatcher", false));
        }
        return this.executorService;
    }

    public final synchronized void setMaxRequests(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("max < 1: " + n2);
        }
        this.maxRequests = n2;
        this.promoteCalls();
    }

    public final synchronized int getMaxRequests() {
        return this.maxRequests;
    }

    public final synchronized void setMaxRequestsPerHost(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("max < 1: " + n2);
        }
        this.maxRequestsPerHost = n2;
        this.promoteCalls();
    }

    public final synchronized int getMaxRequestsPerHost() {
        return this.maxRequestsPerHost;
    }

    public final synchronized void setIdleCallback(Runnable runnable) {
        this.idleCallback = runnable;
    }

    final synchronized void enqueue(RealCall$AsyncCall realCall$AsyncCall) {
        if (this.runningAsyncCalls.size() < this.maxRequests && this.runningCallsForHost(realCall$AsyncCall) < this.maxRequestsPerHost) {
            this.runningAsyncCalls.add(realCall$AsyncCall);
            this.executorService().execute(realCall$AsyncCall);
            return;
        }
        this.readyAsyncCalls.add(realCall$AsyncCall);
    }

    public final synchronized void cancelAll() {
        for (RealCall$AsyncCall object : this.readyAsyncCalls) {
            object.get().cancel();
        }
        for (RealCall$AsyncCall realCall$AsyncCall : this.runningAsyncCalls) {
            realCall$AsyncCall.get().cancel();
        }
        for (RealCall realCall : this.runningSyncCalls) {
            realCall.cancel();
        }
    }

    private void promoteCalls() {
        if (this.runningAsyncCalls.size() >= this.maxRequests) {
            return;
        }
        if (this.readyAsyncCalls.isEmpty()) {
            return;
        }
        Iterator<RealCall$AsyncCall> iterator = this.readyAsyncCalls.iterator();
        while (iterator.hasNext()) {
            RealCall$AsyncCall realCall$AsyncCall = iterator.next();
            if (this.runningCallsForHost(realCall$AsyncCall) < this.maxRequestsPerHost) {
                iterator.remove();
                this.runningAsyncCalls.add(realCall$AsyncCall);
                this.executorService().execute(realCall$AsyncCall);
            }
            if (this.runningAsyncCalls.size() < this.maxRequests) continue;
            return;
        }
    }

    private int runningCallsForHost(RealCall$AsyncCall realCall$AsyncCall) {
        int n2 = 0;
        for (RealCall$AsyncCall realCall$AsyncCall2 : this.runningAsyncCalls) {
            if (!realCall$AsyncCall2.host().equals(realCall$AsyncCall.host())) continue;
            ++n2;
        }
        return n2;
    }

    final synchronized void executed(RealCall realCall) {
        this.runningSyncCalls.add(realCall);
    }

    final void finished(RealCall$AsyncCall realCall$AsyncCall) {
        this.finished(this.runningAsyncCalls, realCall$AsyncCall, true);
    }

    final void finished(RealCall realCall) {
        this.finished(this.runningSyncCalls, realCall, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void finished(Deque<T> deque, T object, boolean bl) {
        int n2;
        Dispatcher dispatcher = this;
        synchronized (dispatcher) {
            if (!deque.remove(object)) {
                throw new AssertionError((Object)"Call wasn't in-flight!");
            }
            if (bl) {
                this.promoteCalls();
            }
            n2 = this.runningCallsCount();
            object = this.idleCallback;
        }
        if (n2 == 0 && object != null) {
            object.run();
        }
    }

    public final synchronized List<Call> queuedCalls() {
        ArrayList<RealCall> arrayList = new ArrayList<RealCall>();
        for (RealCall$AsyncCall realCall$AsyncCall : this.readyAsyncCalls) {
            arrayList.add(realCall$AsyncCall.get());
        }
        return Collections.unmodifiableList(arrayList);
    }

    public final synchronized List<Call> runningCalls() {
        ArrayList<RealCall> arrayList = new ArrayList<RealCall>();
        arrayList.addAll(this.runningSyncCalls);
        for (RealCall$AsyncCall realCall$AsyncCall : this.runningAsyncCalls) {
            arrayList.add(realCall$AsyncCall.get());
        }
        return Collections.unmodifiableList(arrayList);
    }

    public final synchronized int queuedCallsCount() {
        return this.readyAsyncCalls.size();
    }

    public final synchronized int runningCallsCount() {
        return this.runningAsyncCalls.size() + this.runningSyncCalls.size();
    }
}

