/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.okhttp3;

import com.zoyi.io.socket.okhttp3.Cookie;
import com.zoyi.io.socket.okhttp3.internal.Util;

public final class Cookie$Builder {
    String name;
    String value;
    long expiresAt = 253402300799999L;
    String domain;
    String path = "/";
    boolean secure;
    boolean httpOnly;
    boolean persistent;
    boolean hostOnly;

    public final Cookie$Builder name(String string) {
        if (string == null) {
            throw new NullPointerException("name == null");
        }
        if (!string.trim().equals(string)) {
            throw new IllegalArgumentException("name is not trimmed");
        }
        this.name = string;
        return this;
    }

    public final Cookie$Builder value(String string) {
        if (string == null) {
            throw new NullPointerException("value == null");
        }
        if (!string.trim().equals(string)) {
            throw new IllegalArgumentException("value is not trimmed");
        }
        this.value = string;
        return this;
    }

    public final Cookie$Builder expiresAt(long l2) {
        if (l2 <= 0L) {
            l2 = Long.MIN_VALUE;
        }
        if (l2 > 253402300799999L) {
            l2 = 253402300799999L;
        }
        this.expiresAt = l2;
        this.persistent = true;
        return this;
    }

    public final Cookie$Builder domain(String string) {
        return this.domain(string, false);
    }

    public final Cookie$Builder hostOnlyDomain(String string) {
        return this.domain(string, true);
    }

    private Cookie$Builder domain(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("domain == null");
        }
        String string2 = Util.domainToAscii(string);
        if (string2 == null) {
            throw new IllegalArgumentException("unexpected domain: " + string);
        }
        this.domain = string2;
        this.hostOnly = bl;
        return this;
    }

    public final Cookie$Builder path(String string) {
        if (!string.startsWith("/")) {
            throw new IllegalArgumentException("path must start with '/'");
        }
        this.path = string;
        return this;
    }

    public final Cookie$Builder secure() {
        this.secure = true;
        return this;
    }

    public final Cookie$Builder httpOnly() {
        this.httpOnly = true;
        return this;
    }

    public final Cookie build() {
        return new Cookie(this);
    }
}

