/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.okhttp3;

import com.zoyi.io.socket.okhttp3.Cache$1;
import com.zoyi.io.socket.okhttp3.Cache$2;
import com.zoyi.io.socket.okhttp3.Cache$CacheRequestImpl;
import com.zoyi.io.socket.okhttp3.Cache$CacheResponseBody;
import com.zoyi.io.socket.okhttp3.Cache$Entry;
import com.zoyi.io.socket.okhttp3.HttpUrl;
import com.zoyi.io.socket.okhttp3.Request;
import com.zoyi.io.socket.okhttp3.Response;
import com.zoyi.io.socket.okhttp3.internal.Util;
import com.zoyi.io.socket.okhttp3.internal.cache.CacheRequest;
import com.zoyi.io.socket.okhttp3.internal.cache.CacheStrategy;
import com.zoyi.io.socket.okhttp3.internal.cache.DiskLruCache;
import com.zoyi.io.socket.okhttp3.internal.cache.DiskLruCache$Editor;
import com.zoyi.io.socket.okhttp3.internal.cache.DiskLruCache$Snapshot;
import com.zoyi.io.socket.okhttp3.internal.cache.InternalCache;
import com.zoyi.io.socket.okhttp3.internal.http.HttpHeaders;
import com.zoyi.io.socket.okhttp3.internal.http.HttpMethod;
import com.zoyi.io.socket.okhttp3.internal.io.FileSystem;
import com.zoyi.io.socket.okio.BufferedSource;
import com.zoyi.io.socket.okio.ByteString;
import java.io.Closeable;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.util.Iterator;

public final class Cache
implements Closeable,
Flushable {
    private static final int VERSION = 201105;
    private static final int ENTRY_METADATA = 0;
    private static final int ENTRY_BODY = 1;
    private static final int ENTRY_COUNT = 2;
    final InternalCache internalCache = new Cache$1(this);
    final DiskLruCache cache;
    int writeSuccessCount;
    int writeAbortCount;
    private int networkCount;
    private int hitCount;
    private int requestCount;

    public Cache(File file, long l2) {
        this(file, l2, FileSystem.SYSTEM);
    }

    Cache(File file, long l2, FileSystem fileSystem) {
        this.cache = DiskLruCache.create(fileSystem, file, 201105, 2, l2);
    }

    public static String key(HttpUrl httpUrl) {
        return ByteString.encodeUtf8(httpUrl.toString()).md5().hex();
    }

    final Response get(Request request) {
        Cache$Entry cache$Entry;
        Object object = Cache.key(request.url());
        try {
            object = this.cache.get((String)object);
            if (object == null) {
                return null;
            }
        }
        catch (IOException iOException) {
            return null;
        }
        try {
            cache$Entry = new Cache$Entry(((DiskLruCache$Snapshot)object).getSource(0));
        }
        catch (IOException iOException) {
            Util.closeQuietly((Closeable)object);
            return null;
        }
        object = cache$Entry.response((DiskLruCache$Snapshot)object);
        if (!cache$Entry.matches(request, (Response)object)) {
            Util.closeQuietly(((Response)object).body());
            return null;
        }
        return object;
    }

    final CacheRequest put(Response response) {
        Object object = response.request().method();
        if (HttpMethod.invalidatesCache(response.request().method())) {
            try {
                this.remove(response.request());
            }
            catch (IOException iOException) {}
            return null;
        }
        if (!((String)object).equals("GET")) {
            return null;
        }
        if (HttpHeaders.hasVaryAll(response)) {
            return null;
        }
        object = new Cache$Entry(response);
        DiskLruCache$Editor diskLruCache$Editor = null;
        try {
            diskLruCache$Editor = this.cache.edit(Cache.key(response.request().url()));
            if (diskLruCache$Editor == null) {
                return null;
            }
            ((Cache$Entry)object).writeTo(diskLruCache$Editor);
            return new Cache$CacheRequestImpl(this, diskLruCache$Editor);
        }
        catch (IOException iOException) {
            this.abortQuietly(diskLruCache$Editor);
            return null;
        }
    }

    final void remove(Request request) throws IOException {
        this.cache.remove(Cache.key(request.url()));
    }

    final void update(Response closeable, Response object) {
        object = new Cache$Entry((Response)object);
        closeable = ((Cache$CacheResponseBody)((Response)closeable).body()).snapshot;
        DiskLruCache$Editor diskLruCache$Editor = null;
        try {
            diskLruCache$Editor = ((DiskLruCache$Snapshot)closeable).edit();
            if (diskLruCache$Editor != null) {
                ((Cache$Entry)object).writeTo(diskLruCache$Editor);
                diskLruCache$Editor.commit();
            }
            return;
        }
        catch (IOException iOException) {
            this.abortQuietly(diskLruCache$Editor);
            return;
        }
    }

    private void abortQuietly(DiskLruCache$Editor diskLruCache$Editor) {
        try {
            if (diskLruCache$Editor != null) {
                diskLruCache$Editor.abort();
            }
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public final void initialize() throws IOException {
        this.cache.initialize();
    }

    public final void delete() throws IOException {
        this.cache.delete();
    }

    public final void evictAll() throws IOException {
        this.cache.evictAll();
    }

    public final Iterator<String> urls() throws IOException {
        return new Cache$2(this);
    }

    public final synchronized int writeAbortCount() {
        return this.writeAbortCount;
    }

    public final synchronized int writeSuccessCount() {
        return this.writeSuccessCount;
    }

    public final long size() throws IOException {
        return this.cache.size();
    }

    public final long maxSize() {
        return this.cache.getMaxSize();
    }

    @Override
    public final void flush() throws IOException {
        this.cache.flush();
    }

    @Override
    public final void close() throws IOException {
        this.cache.close();
    }

    public final File directory() {
        return this.cache.getDirectory();
    }

    public final boolean isClosed() {
        return this.cache.isClosed();
    }

    final synchronized void trackResponse(CacheStrategy cacheStrategy) {
        ++this.requestCount;
        if (cacheStrategy.networkRequest != null) {
            ++this.networkCount;
            return;
        }
        if (cacheStrategy.cacheResponse != null) {
            ++this.hitCount;
        }
    }

    final synchronized void trackConditionalCacheHit() {
        ++this.hitCount;
    }

    public final synchronized int networkCount() {
        return this.networkCount;
    }

    public final synchronized int hitCount() {
        return this.hitCount;
    }

    public final synchronized int requestCount() {
        return this.requestCount;
    }

    static int readInt(BufferedSource object) throws IOException {
        try {
            long l2 = object.readDecimalLong();
            object = object.readUtf8LineStrict();
            if (l2 < 0L || l2 > Integer.MAX_VALUE || !((String)object).isEmpty()) {
                throw new IOException("expected an int but was \"" + l2 + (String)object + "\"");
            }
            return (int)l2;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException(numberFormatException.getMessage());
        }
    }
}

