/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.client;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.regex.Pattern;

public class Url {
    private static Pattern PATTERN_HTTP = Pattern.compile("^http|ws$");
    private static Pattern PATTERN_HTTPS = Pattern.compile("^(http|ws)s$");

    private Url() {
    }

    public static URL parse(String string) throws URISyntaxException {
        return Url.parse(new URI(string));
    }

    public static URL parse(URI uRI) {
        String string;
        int n2;
        String string2 = uRI.getScheme();
        if (string2 == null || !string2.matches("^https?|wss?$")) {
            string2 = "https";
        }
        if ((n2 = uRI.getPort()) == -1) {
            if (PATTERN_HTTP.matcher(string2).matches()) {
                n2 = 80;
            } else if (PATTERN_HTTPS.matcher(string2).matches()) {
                n2 = 443;
            }
        }
        if ((string = uRI.getRawPath()) == null || string.length() == 0) {
            string = "/";
        }
        String string3 = uRI.getRawUserInfo();
        String string4 = uRI.getRawQuery();
        String string5 = uRI.getRawFragment();
        try {
            return new URL(string2 + "://" + (string3 != null ? string3 + "@" : "") + uRI.getHost() + (n2 != -1 ? ":" + n2 : "") + string + (string4 != null ? "?" + string4 : "") + (string5 != null ? "#" + string5 : ""));
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    public static String extractId(String string) throws MalformedURLException {
        return Url.extractId(new URL(string));
    }

    public static String extractId(URL uRL) {
        String string = uRL.getProtocol();
        int n2 = uRL.getPort();
        if (n2 == -1) {
            if (PATTERN_HTTP.matcher(string).matches()) {
                n2 = 80;
            } else if (PATTERN_HTTPS.matcher(string).matches()) {
                n2 = 443;
            }
        }
        return string + "://" + uRL.getHost() + ":" + n2;
    }
}

