/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.external.fab;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.StateListDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.AbsListView;
import android.widget.ImageButton;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.view.external.fab.ObservableScrollView;
import com.zoyi.channel.plugin.android.view.external.fab.ObservableScrollView$OnScrollChangedListener;
import com.zoyi.channel.plugin.android.view.external.fab.ScrollDirectionListener;
import com.zoyi.channel.plugin.android.view.external.fab.b;
import com.zoyi.channel.plugin.android.view.external.fab.c;
import com.zoyi.channel.plugin.android.view.external.fab.d;
import com.zoyi.channel.plugin.android.view.external.fab.e;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.view.ViewHelper;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.view.ViewPropertyAnimator;

public class FloatingActionButton
extends ImageButton {
    private static final int TRANSLATE_DURATION_MILLIS = 200;
    public static final int TYPE_NORMAL = 0;
    public static final int TYPE_MINI = 1;
    private boolean mVisible;
    private int mColorNormal;
    private int mColorPressed;
    private int mColorRipple;
    private int mColorDisabled;
    private boolean mShadow;
    private int mType;
    private int mShadowSize;
    private int mScrollThreshold;
    private boolean mMarginsSet;
    private final Interpolator mInterpolator = new AccelerateDecelerateInterpolator();

    public FloatingActionButton(Context context) {
        this(context, null);
    }

    public FloatingActionButton(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init(context, attributeSet);
    }

    public FloatingActionButton(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.init(context, attributeSet);
    }

    protected void onMeasure(int n2, int n3) {
        super.onMeasure(n2, n3);
        n2 = this.getDimension(this.mType == 0 ? R.dimen.ch_fab_size_normal : R.dimen.ch_fab_size_mini);
        if (this.mShadow) {
            n2 += this.mShadowSize << 1;
            this.setMarginsWithoutShadow();
        }
        this.setMeasuredDimension(n2, n2);
    }

    private void init(Context context, AttributeSet attributeSet) {
        this.mVisible = true;
        this.mColorNormal = this.getColor(R.color.ch_material_blue_500);
        this.mColorPressed = FloatingActionButton.darkenColor(this.mColorNormal);
        this.mColorRipple = FloatingActionButton.lightenColor(this.mColorNormal);
        this.mColorDisabled = this.getColor(0x1060000);
        this.mType = 0;
        this.mShadow = true;
        this.mScrollThreshold = this.getResources().getDimensionPixelOffset(R.dimen.ch_fab_scroll_threshold);
        this.mShadowSize = this.getDimension(R.dimen.ch_fab_shadow_size);
        if (attributeSet != null) {
            this.initAttributes(context, attributeSet);
        }
        this.updateBackground();
    }

    private void initAttributes(Context context, AttributeSet attributeSet) {
        if ((context = this.getTypedArray(context, attributeSet, R.styleable.FloatingActionButton)) != null) {
            try {
                this.mColorNormal = context.getColor(R.styleable.FloatingActionButton_ch_fab_colorNormal, this.getColor(R.color.ch_material_blue_500));
                this.mColorPressed = context.getColor(R.styleable.FloatingActionButton_ch_fab_colorPressed, FloatingActionButton.darkenColor(this.mColorNormal));
                this.mColorRipple = context.getColor(R.styleable.FloatingActionButton_ch_fab_colorRipple, FloatingActionButton.lightenColor(this.mColorNormal));
                this.mColorDisabled = context.getColor(R.styleable.FloatingActionButton_ch_fab_colorDisabled, this.mColorDisabled);
                this.mShadow = context.getBoolean(R.styleable.FloatingActionButton_ch_fab_shadow, true);
                this.mType = context.getInt(R.styleable.FloatingActionButton_ch_fab_type, 0);
                return;
            }
            finally {
                context.recycle();
            }
        }
    }

    private void updateBackground() {
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{16842919}, this.createDrawable(this.mColorPressed));
        stateListDrawable.addState(new int[]{-16842910}, this.createDrawable(this.mColorDisabled));
        stateListDrawable.addState(new int[0], this.createDrawable(this.mColorNormal));
        this.setBackgroundCompat((Drawable)stateListDrawable);
    }

    private Drawable createDrawable(int n2) {
        OvalShape ovalShape = new OvalShape();
        ovalShape = new ShapeDrawable((Shape)ovalShape);
        ovalShape.getPaint().setColor(n2);
        if (this.mShadow) {
            Drawable drawable2 = this.getResources().getDrawable(this.mType == 0 ? R.drawable.ch_plugin_fab_shadow : R.drawable.ch_plugin_fab_shadow_mini);
            drawable2 = new LayerDrawable(new Drawable[]{drawable2, ovalShape});
            drawable2.setLayerInset(1, this.mShadowSize, this.mShadowSize, this.mShadowSize, this.mShadowSize);
            return drawable2;
        }
        return ovalShape;
    }

    private TypedArray getTypedArray(Context context, AttributeSet attributeSet, int[] nArray) {
        return context.obtainStyledAttributes(attributeSet, nArray, 0, 0);
    }

    private int getColor(@ColorRes int n2) {
        return this.getResources().getColor(n2);
    }

    private int getDimension(@DimenRes int n2) {
        return this.getResources().getDimensionPixelSize(n2);
    }

    private void setMarginsWithoutShadow() {
        if (!this.mMarginsSet && this.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)this.getLayoutParams();
            int n2 = marginLayoutParams.leftMargin - this.mShadowSize;
            int n3 = marginLayoutParams.topMargin - this.mShadowSize;
            int n4 = marginLayoutParams.rightMargin - this.mShadowSize;
            int n5 = marginLayoutParams.bottomMargin - this.mShadowSize;
            marginLayoutParams.setMargins(n2, n3, n4, n5);
            this.requestLayout();
            this.mMarginsSet = true;
        }
    }

    @SuppressLint(value={"NewApi"})
    private void setBackgroundCompat(Drawable drawable2) {
        if (this.hasJellyBeanApi()) {
            this.setBackground(drawable2);
            return;
        }
        this.setBackgroundDrawable(drawable2);
    }

    private int getMarginBottom() {
        int n2 = 0;
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        if (layoutParams instanceof ViewGroup.MarginLayoutParams) {
            n2 = ((ViewGroup.MarginLayoutParams)layoutParams).bottomMargin;
        }
        return n2;
    }

    public void setColorNormal(int n2) {
        if (n2 != this.mColorNormal) {
            this.mColorNormal = n2;
            this.updateBackground();
        }
    }

    public void setColorNormalResId(@ColorRes int n2) {
        this.setColorNormal(this.getColor(n2));
    }

    public int getColorNormal() {
        return this.mColorNormal;
    }

    public void setColorPressed(int n2) {
        if (n2 != this.mColorPressed) {
            this.mColorPressed = n2;
            this.updateBackground();
        }
    }

    public void setColorPressedResId(@ColorRes int n2) {
        this.setColorPressed(this.getColor(n2));
    }

    public int getColorPressed() {
        return this.mColorPressed;
    }

    public void setColorRipple(int n2) {
        if (n2 != this.mColorRipple) {
            this.mColorRipple = n2;
            this.updateBackground();
        }
    }

    public void setColorRippleResId(@ColorRes int n2) {
        this.setColorRipple(this.getColor(n2));
    }

    public int getColorRipple() {
        return this.mColorRipple;
    }

    public void setShadow(boolean bl) {
        if (bl != this.mShadow) {
            this.mShadow = bl;
            this.updateBackground();
        }
    }

    public boolean hasShadow() {
        return this.mShadow;
    }

    public void setType(int n2) {
        if (n2 != this.mType) {
            this.mType = n2;
            this.updateBackground();
        }
    }

    public int getType() {
        return this.mType;
    }

    public boolean isVisible() {
        return this.mVisible;
    }

    public void show() {
        this.show(true);
    }

    public void hide() {
        this.hide(true);
    }

    public void show(boolean bl) {
        this.toggle(true, bl, false);
    }

    public void hide(boolean bl) {
        this.toggle(false, bl, false);
    }

    private void toggle(boolean bl, boolean bl2, boolean n2) {
        if (this.mVisible != bl || n2 != 0) {
            ViewTreeObserver viewTreeObserver;
            this.mVisible = bl;
            int n3 = this.getHeight();
            if (n3 == 0 && n2 == 0 && (viewTreeObserver = this.getViewTreeObserver()).isAlive()) {
                viewTreeObserver.addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)new b(this, bl, bl2));
                return;
            }
            int n4 = n2 = bl ? 0 : n3 + this.getMarginBottom();
            if (bl2) {
                ViewPropertyAnimator.animate((View)this).setInterpolator(this.mInterpolator).setDuration(200L).translationY(n2);
            } else {
                ViewHelper.setTranslationY((View)this, n2);
            }
            if (!this.hasHoneycombApi()) {
                this.setClickable(bl);
            }
        }
    }

    public void attachToListView(@NonNull AbsListView absListView) {
        this.attachToListView(absListView, null, null);
    }

    public void attachToListView(@NonNull AbsListView absListView, ScrollDirectionListener scrollDirectionListener) {
        this.attachToListView(absListView, scrollDirectionListener, null);
    }

    public void attachToRecyclerView(@NonNull RecyclerView recyclerView) {
        this.attachToRecyclerView(recyclerView, null, null);
    }

    public void attachToRecyclerView(@NonNull RecyclerView recyclerView, ScrollDirectionListener scrollDirectionListener) {
        this.attachToRecyclerView(recyclerView, scrollDirectionListener, null);
    }

    public void attachToScrollView(@NonNull ObservableScrollView observableScrollView) {
        this.attachToScrollView(observableScrollView, null, null);
    }

    public void attachToScrollView(@NonNull ObservableScrollView observableScrollView, ScrollDirectionListener scrollDirectionListener) {
        this.attachToScrollView(observableScrollView, scrollDirectionListener, null);
    }

    public void attachToListView(@NonNull AbsListView absListView, ScrollDirectionListener scrollDirectionListener, AbsListView.OnScrollListener onScrollListener) {
        c c2 = new c(this, 0);
        c.a(c2, scrollDirectionListener);
        c2.a(onScrollListener);
        c2.a(absListView);
        c2.a(this.mScrollThreshold);
        absListView.setOnScrollListener((AbsListView.OnScrollListener)c2);
    }

    public void attachToRecyclerView(@NonNull RecyclerView recyclerView, ScrollDirectionListener scrollDirectionListener, RecyclerView.OnScrollListener onScrollListener) {
        d d2 = new d(this, 0);
        d.a(d2, scrollDirectionListener);
        d2.a(onScrollListener);
        d2.a(this.mScrollThreshold);
        recyclerView.setOnScrollListener((RecyclerView.OnScrollListener)d2);
    }

    public void attachToScrollView(@NonNull ObservableScrollView observableScrollView, ScrollDirectionListener scrollDirectionListener, ObservableScrollView$OnScrollChangedListener observableScrollView$OnScrollChangedListener) {
        e e2 = new e(this, 0);
        e.a(e2, scrollDirectionListener);
        e2.a(observableScrollView$OnScrollChangedListener);
        e2.a(this.mScrollThreshold);
        observableScrollView.setOnScrollChangedListener(e2);
    }

    private boolean hasLollipopApi() {
        return Build.VERSION.SDK_INT >= 21;
    }

    private boolean hasJellyBeanApi() {
        return Build.VERSION.SDK_INT >= 16;
    }

    private boolean hasHoneycombApi() {
        return Build.VERSION.SDK_INT >= 11;
    }

    private static int darkenColor(int n2) {
        float[] fArray = new float[3];
        Color.colorToHSV((int)n2, (float[])fArray);
        fArray[2] = fArray[2] * 0.9f;
        return Color.HSVToColor((float[])fArray);
    }

    private static int lightenColor(int n2) {
        float[] fArray = new float[3];
        Color.colorToHSV((int)n2, (float[])fArray);
        fArray[2] = fArray[2] * 1.1f;
        return Color.HSVToColor((float[])fArray);
    }

    static /* synthetic */ void access$000(FloatingActionButton floatingActionButton, boolean bl, boolean bl2, boolean bl3) {
        floatingActionButton.toggle(bl, bl2, bl3);
    }
}

