/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat;

import android.support.v4.util.LongSparseArray;
import com.zoyi.channel.plugin.android.ChannelPlugin;
import com.zoyi.channel.plugin.android.activity.chat.g;
import com.zoyi.channel.plugin.android.activity.chat.h;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnMessageSendListener;
import com.zoyi.channel.plugin.android.activity.chat.model.MessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.SendingMessageItem;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.RequestUtils;
import com.zoyi.retrofit2.okhttp3.MediaType;
import com.zoyi.retrofit2.okhttp3.MultipartBody$Part;
import com.zoyi.retrofit2.okhttp3.RequestBody;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class ChatManager {
    private static ChatManager chatManager;
    private boolean sending = false;
    private boolean released = false;
    private Queue<SendingMessageItem> sendingItems = new LinkedList<SendingMessageItem>();
    private LongSparseArray<SendingMessageItem> failedItems = new LongSparseArray();
    private OnMessageSendListener listener;

    public static ChatManager get() {
        if (chatManager == null) {
            chatManager = new ChatManager();
        }
        return chatManager;
    }

    public void setOnMessageSendListener(OnMessageSendListener onMessageSendListener) {
        this.listener = onMessageSendListener;
    }

    public void removeFailedItem(Long l2) {
        if (l2 != null) {
            this.failedItems.remove(l2.longValue());
        }
    }

    public void send(String string, List<SendingMessageItem> object) {
        if (!this.released) {
            object = object.iterator();
            while (object.hasNext()) {
                SendingMessageItem sendingMessageItem = (SendingMessageItem)object.next();
                sendingMessageItem.setChatId(string);
                this.send(sendingMessageItem);
            }
        }
    }

    public void send(List<SendingMessageItem> object) {
        if (!this.released) {
            object = object.iterator();
            while (object.hasNext()) {
                SendingMessageItem sendingMessageItem = (SendingMessageItem)object.next();
                this.send(sendingMessageItem);
            }
        }
    }

    public void send(SendingMessageItem sendingMessageItem) {
        if (!this.released && sendingMessageItem != null && sendingMessageItem.getCreatedAt() != null) {
            this.removeFailedItem(sendingMessageItem.getCreatedAt());
            sendingMessageItem.setSending(true);
            this.sendingItems.add(sendingMessageItem);
            this.send();
        }
    }

    private void send() {
        if (!this.sending && this.sendingItems.size() > 0) {
            this.sending = true;
            SendingMessageItem sendingMessageItem = this.sendingItems.poll();
            if (sendingMessageItem.isImage()) {
                this.sendFileMessage(sendingMessageItem);
                return;
            }
            this.sendTextMessage(sendingMessageItem);
        }
    }

    private void sendTextMessage(SendingMessageItem sendingMessageItem) {
        RequestBody requestBody = RequestUtils.form().set("message", sendingMessageItem.getMessage()).set("requestId", sendingMessageItem.getRequestId()).create();
        ChannelPlugin.getApi().sendMessage(sendingMessageItem.getChatId(), requestBody).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe(new g(this, sendingMessageItem));
    }

    private void sendFileMessage(SendingMessageItem sendingMessageItem) {
        MultipartBody$Part multipartBody$Part = RequestUtils.makeMultipart(sendingMessageItem.getString());
        RequestBody requestBody = RequestBody.create(MediaType.parse("text/plane"), sendingMessageItem.getRequestId());
        if (multipartBody$Part == null) {
            this.failed(new Exception("Not supported type"), sendingMessageItem);
            return;
        }
        ChannelPlugin.getApi().uploadFile(sendingMessageItem.getChatId(), multipartBody$Part, requestBody).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe(new h(this, sendingMessageItem));
    }

    private void successed(SendingMessageItem sendingMessageItem, Message message) {
        if (!this.released) {
            if (this.listener != null) {
                this.listener.sendSuccessed(sendingMessageItem, message);
            }
            this.sending = false;
            this.send();
        }
    }

    private void failed(Exception exception, SendingMessageItem sendingMessageItem) {
        if (exception != null) {
            L.e(exception.getMessage());
        }
        if (!this.released) {
            sendingMessageItem.setSending(false);
            this.failedItems.put(sendingMessageItem.getCreatedAt().longValue(), (Object)sendingMessageItem);
            if (this.listener != null) {
                this.listener.sendFailed(sendingMessageItem);
            }
            this.sending = false;
            this.send();
        }
    }

    public List<MessageItem> getFailedItems(String string) {
        ArrayList<MessageItem> arrayList = new ArrayList<MessageItem>();
        for (int i2 = 0; i2 < this.failedItems.size(); ++i2) {
            SendingMessageItem sendingMessageItem = (SendingMessageItem)this.failedItems.valueAt(i2);
            if (!CompareUtils.isSame(string, sendingMessageItem.getChatId())) continue;
            arrayList.add(sendingMessageItem);
        }
        return arrayList;
    }

    public static void release() {
        if (chatManager != null) {
            ChatManager.chatManager.released = true;
            ChatManager.chatManager.sendingItems.clear();
            ChatManager.chatManager.failedItems.clear();
            chatManager = null;
        }
    }

    static /* synthetic */ void access$000(ChatManager chatManager, Exception exception, SendingMessageItem sendingMessageItem) {
        chatManager.failed(exception, sendingMessageItem);
    }

    static /* synthetic */ void access$100(ChatManager chatManager, SendingMessageItem sendingMessageItem, Message message) {
        chatManager.successed(sendingMessageItem, message);
    }
}

