/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mint.network.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;

public final class ReflectionUtil {
    public static final boolean includeObject = false;

    public static Constructor<?> findConstructor(String genericDeclarationArray, Class<?>[] classArray) throws ClassNotFoundException {
        genericDeclarationArray = Class.forName((String)genericDeclarationArray).getDeclaredConstructors();
        Constructor<?>[] constructorArray = genericDeclarationArray;
        int n2 = genericDeclarationArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Constructor<?> constructor = constructorArray[i2];
            genericDeclarationArray = constructor.getParameterTypes();
            if (genericDeclarationArray.length != classArray.length) continue;
            boolean bl = true;
            for (int i3 = 0; i3 < genericDeclarationArray.length; ++i3) {
                if (genericDeclarationArray[i3].equals(classArray[i3])) continue;
                bl = false;
            }
            if (!bl) continue;
            return constructor;
        }
        return null;
    }

    public static Set<Class<?>> getAllSuperTypes(Class<?> classArray) {
        HashSet hashSet = new HashSet();
        if (classArray != null && !classArray.equals(Object.class)) {
            hashSet.add((Class<?>)classArray);
            hashSet.addAll(ReflectionUtil.getAllSuperTypes(classArray.getSuperclass()));
            for (Class<?> clazz : classArray.getInterfaces()) {
                hashSet.addAll(ReflectionUtil.getAllSuperTypes(clazz));
            }
        }
        return hashSet;
    }

    public static Set<Method> getAllMethods(Class<?> object) {
        HashSet<Method> hashSet = new HashSet<Method>();
        for (Class<?> clazz : ReflectionUtil.getAllSuperTypes(object)) {
            for (Method method : clazz.getDeclaredMethods()) {
                hashSet.add(method);
            }
        }
        return hashSet;
    }

    public static String extractCallingMethod(String[] stringArray) {
        StackTraceElement[] stackTraceElementArray = new Throwable();
        for (StackTraceElement stackTraceElement : stackTraceElementArray.getStackTrace()) {
            if (ReflectionUtil.inExcluded(stackTraceElement.getClassName(), stringArray)) continue;
            return stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName() + ":" + stackTraceElement.getLineNumber();
        }
        return null;
    }

    public static boolean callingClassAnyOf(String[] stringArray) {
        StackTraceElement[] stackTraceElementArray = new Throwable();
        for (StackTraceElement stackTraceElement : stackTraceElementArray.getStackTrace()) {
            if (!ReflectionUtil.contains(stackTraceElement.getClassName(), stringArray)) continue;
            return true;
        }
        return false;
    }

    public static final boolean contains(String string, String[] stringArray) {
        for (String string2 : stringArray) {
            if (!string.contains(string2)) continue;
            return true;
        }
        return false;
    }

    private static final boolean inExcluded(String string, String[] stringArray) {
        for (String string2 : stringArray) {
            if (!string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }
}

