/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mint;

import android.content.Context;
import com.splunk.mint.BaseDTO;
import com.splunk.mint.DataSaver;
import com.splunk.mint.InterfaceDataType;
import com.splunk.mint.Logger;
import com.splunk.mint.MintLogLevel;
import com.splunk.mint.NetSender;
import com.splunk.mint.Properties;
import com.splunk.mint.Properties$RemoteSettingsProps;
import com.splunk.mint.Utils;
import org.json.JSONException;
import org.json.JSONObject;

class ActionLog
extends BaseDTO
implements InterfaceDataType {
    public String eventName = "";
    public Integer eventLevel = 2;

    public ActionLog(byte by, String string, Integer n2) {
        super(by, null);
        this.eventName = string;
        this.eventLevel = n2;
    }

    public static final ActionLog createLog(String string, MintLogLevel mintLogLevel) {
        return new ActionLog(9, string, Utils.convertLoggingLevelToInt(mintLogLevel));
    }

    @Override
    public String toJsonLine() {
        JSONObject jSONObject = this.getBasicDataFixtureJson();
        try {
            jSONObject.put("log_name", (Object)this.eventName);
            jSONObject.put("level", (Object)this.eventLevel);
        }
        catch (JSONException jSONException) {
            JSONException jSONException2 = jSONException;
            jSONException.printStackTrace();
        }
        return jSONObject.toString() + Properties.getSeparator(this.type);
    }

    @Override
    public void send(Context context, boolean bl) {
        NetSender.send(this.toJsonLine(), bl);
    }

    @Override
    public void save() {
        if (this.eventLevel != null && this.eventLevel < Properties$RemoteSettingsProps.logLevel) {
            Logger.logInfo("Logs's level is lower than the minimum level from Remote Settings, log will not be saved");
            return;
        }
        DataSaver.save(this.toJsonLine());
    }

    @Override
    public void send(boolean bl) {
        NetSender.send(this.toJsonLine(), bl);
    }
}

