package com.zoyi.channel.plugin.android.network;

import com.zoyi.channel.plugin.android.ChannelPlugin;
import com.zoyi.com.google.gson.Gson;
import com.zoyi.retrofit2.Retrofit;
import com.zoyi.retrofit2.converter.gson.GsonConverterFactory;
import com.zoyi.retrofit2.okhttp3.OkHttpClient;
import com.zoyi.retrofit2.okhttp3.logging.HttpLoggingInterceptor;

/**
 * Created by mika on 2016. 1. 20..
 */
public class ServiceFactory {
  public static ChannelApi create() {
    final String ENDPOINT = "https://api.channel.io/";
//    final String ENDPOINT = "http://api.exp.channel.io/";

    HttpLoggingInterceptor interceptor = new HttpLoggingInterceptor()
        .setLevel(ChannelPlugin.isDebugMode()
            ? HttpLoggingInterceptor.Level.HEADERS
            : HttpLoggingInterceptor.Level.NONE);
    OkHttpClient client = new OkHttpClient.Builder()
        .addInterceptor(new RetrofitInterceptor())
        .addInterceptor(interceptor)
        .build();

    return new Retrofit.Builder()
        .baseUrl(ENDPOINT)
        .client(client)
        .addCallAdapterFactory(RxAdapterFactory.create())
        .addConverterFactory(GsonConverterFactory.create(new Gson()))
        .build()
        .create(ChannelApi.class);
  }
}
