package com.zoyi.channel.plugin.android.lib;

import android.content.Context;
import android.content.DialogInterface;
import android.support.annotation.NonNull;
import android.support.v7.app.AlertDialog;

import com.zoyi.channel.plugin.android.activity.chat.CountryDictionary;

import java.util.ArrayList;
import java.util.List;

public class CountryCodeDialog extends AlertDialog.Builder {

  public interface OnCountryCodeSelectListener {

    void onCountryCodeSelected(String countryCode);
  }

  private CountryDictionary countryDictionary;

  private String selectedCode;
  private int checkedItem = -1;

  public CountryCodeDialog(
      @NonNull Context context,
      String selectedCode,
      final OnCountryCodeSelectListener listener) {
    super(context);

    this.selectedCode = selectedCode;
    countryDictionary = new CountryDictionary(context);

    setSingleChoiceItems(getItems(), checkedItem, new DialogInterface.OnClickListener() {
      @Override
      public void onClick(DialogInterface dialog, int which) {
        if (listener != null) {
          listener.onCountryCodeSelected(countryDictionary.getCode(which));
        }
        dialog.dismiss();
      }
    });
  }

  private String[] getItems() {
    ArrayList<String> items = new ArrayList<>();
    List<String> countryNames = countryDictionary.getCountryNames();

    for (int i=0; i<countryNames.size(); i++) {
      String countryName = countryNames.get(i);
      String code = countryDictionary.getCode(i);

      if (selectedCode.contains(code)) {
        checkedItem = i;
      }
      items.add(String.format("%s (+%s)", countryName, code));
    }
    return items.toArray(new String[items.size()]);
  }
}
