package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.view.View;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnSendingMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.model.SendingMessageItem;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.com.bumptech.glide.Glide;

/**
 * Created by mika on 2017. 3. 2..
 */
public class SendingMessageHolder extends UserMessageHolder implements View.OnClickListener {
  private View resendTextButton, resendImageButton;

  private OnSendingMessageClickListener onSendingMessageClickListener;

  public SendingMessageHolder(
      View itemView,
      OnSendingMessageClickListener listener,
      int backColor,
      int textColor) {
    super(itemView, null, backColor, textColor);

    this.onSendingMessageClickListener = listener;

    resendTextButton = itemView.findViewById(R.id.button_text_resend);
    resendImageButton = itemView.findViewById(R.id.button_image_resend);

    resendTextButton.setOnClickListener(this);
    resendImageButton.setOnClickListener(this);
  }

  public void set(SendingMessageItem item) {
    this.sendingMessageItem = item;
    this.message = null;

    setLayout(true, null);

    if (item.isImage()) {
      messageView.setVisibility(View.GONE);
      contentLayout.setVisibility(View.VISIBLE);
      for (int i = 0; i < contentLayout.getChildCount(); i++) {
        contentLayout.getChildAt(i).setVisibility(View.GONE);
      }

      Glide.with(itemView.getContext())
          .load(item.getString())
          .asBitmap()
          .dontAnimate()
          .centerCrop()
          .into(imageUploading);

      uploadLayout.setVisibility(View.VISIBLE);
      imagePlaceholder.setVisibility(View.GONE);
      progressUpload.setVisibility(UIUtils.getVisible(item.isSending(), true));
      imageUploadFailed.setVisibility(UIUtils.getVisible(!item.isSending(), true));
    } else {
      messageView.setVisibility(View.VISIBLE);
      contentLayout.setVisibility(View.GONE);
      setText(item.getString());
    }

    resendTextButton.setVisibility(UIUtils.getVisible(!item.isSending(), true));
    resendImageButton.setVisibility(UIUtils.getVisible(!item.isSending(), true));
  }

  @Override
  public void onClick(View v) {
    if (onSendingMessageClickListener != null && sendingMessageItem != null) {
      onSendingMessageClickListener.sendingMessageClicked(sendingMessageItem);
    }
  }
}
