/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.util.atomic;

import com.zoyi.rx.internal.util.atomic.LinkedQueueNode;
import java.util.AbstractQueue;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;

abstract class BaseLinkedAtomicQueue<E>
extends AbstractQueue<E> {
    private final AtomicReference<LinkedQueueNode<E>> producerNode = new AtomicReference();
    private final AtomicReference<LinkedQueueNode<E>> consumerNode = new AtomicReference();

    protected final LinkedQueueNode<E> lvProducerNode() {
        return this.producerNode.get();
    }

    protected final LinkedQueueNode<E> lpProducerNode() {
        return this.producerNode.get();
    }

    protected final void spProducerNode(LinkedQueueNode<E> node) {
        this.producerNode.lazySet(node);
    }

    protected final LinkedQueueNode<E> xchgProducerNode(LinkedQueueNode<E> node) {
        return this.producerNode.getAndSet(node);
    }

    protected final LinkedQueueNode<E> lvConsumerNode() {
        return this.consumerNode.get();
    }

    protected final LinkedQueueNode<E> lpConsumerNode() {
        return this.consumerNode.get();
    }

    protected final void spConsumerNode(LinkedQueueNode<E> node) {
        this.consumerNode.lazySet(node);
    }

    @Override
    public final Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int size() {
        int size;
        LinkedQueueNode<E> chaserNode = this.lvConsumerNode();
        LinkedQueueNode<E> producerNode = this.lvProducerNode();
        for (size = 0; chaserNode != producerNode && size < Integer.MAX_VALUE; ++size) {
            LinkedQueueNode<E> next;
            while ((next = chaserNode.lvNext()) == null) {
            }
            chaserNode = next;
        }
        return size;
    }

    @Override
    public final boolean isEmpty() {
        return this.lvConsumerNode() == this.lvProducerNode();
    }
}

