package com.zoyi.channel.plugin.android.activity.settings.edit;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.text.InputType;
import android.text.TextUtils;
import android.view.View;

import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.lib.CountryCodeDialog;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.layout.MenuButton;

import java.util.Locale;

public class EditMobileNumberActivity extends ProfileEditActivity
    implements View.OnClickListener, CountryCodeDialog.OnCountryCodeSelectListener {

  private String mobileNumber;

  @Override
  protected void onCreate(@Nullable Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);

    setBigBarTitle(ResUtils.getString(this, "ch.settings.phone_number_placeholder"));
    textLabel.setText(ResUtils.getString(this, "ch.settings.edit.phone_number_label"));
    editText.setHint(ResUtils.getString(this, "ch.settings.edit.phone_number_placeholder"));
    textDescription.setText(ResUtils.getString(this, "ch.settings.edit.phone_number_description"));

    textCountryCode.setOnClickListener(this);
    editText.setInputType(InputType.TYPE_CLASS_NUMBER | InputType.TYPE_NUMBER_FLAG_DECIMAL);

    if (getIntent() != null) {
      String value = getIntent().getStringExtra(Const.EXTRA_INPUT_VALUE);

      if (TextUtils.isEmpty(value)) {
        mobileNumber = textCountryCode.getText().toString();
      } else {
        mobileNumber = value;
        setMobileNumberAndCountryCode(mobileNumber);
      }
    }
    setEditTextPadding((int) Utils.dpToPx(this, 6));
  }

  @Override
  public void onWatchedTextChanged(String s) {
    s = s.trim();

    if (TextUtils.isEmpty(s)) {
      imageDelete.setVisibility(View.INVISIBLE);
      getBigBar().setMenuState(MenuButton.ActionType.DONE, MenuButton.MenuState.VISIBLE);
    } else {
      imageDelete.setVisibility(View.VISIBLE);
      getBigBar().setMenuState(
          MenuButton.ActionType.DONE,
          mobileNumber.equals(getMobileNumber()) ? MenuButton.MenuState.DISABLED : MenuButton.MenuState.VISIBLE);
    }
  }

  @Override
  public void optionClicked(MenuButton.ActionType actionType) {
    super.optionClicked(actionType);

    switch (actionType) {
      case DONE:
        presenter.updateUserMobileNumber(getMobileNumber());
        break;
    }
  }

  @Override
  public void onClick(View v) {
    super.onClick(v);

    int id = v.getId();
    if (id == R.id.tv_edit_country_code) {
      new CountryCodeDialog(this, textCountryCode.getText().toString(), this).show();
    }
  }

  @Override
  protected void setEditTextPadding(int padding) {
    editText.setPadding(padding, 0, padding, 0);
  }

  @Override
  public void onCountryCodeSelected(String countryCode) {
    textCountryCode.setText(String.format("+%s", countryCode));
  }

  private void setMobileNumberAndCountryCode(String mobileNumber) {
    if (TextUtils.isEmpty(mobileNumber)) {
      return;
    }

    try {
      Phonenumber.PhoneNumber phonenumber = PhoneNumberUtil.getInstance().parse(mobileNumber, "");
      String number = Long.toString(phonenumber.getNationalNumber());

      textCountryCode.setText(String.format(Locale.US, "+%d", phonenumber.getCountryCode()));
      editText.setText(number);
      editText.setSelection(number.length());

      onWatchedTextChanged(number);
    } catch (NumberParseException e) {
      e.printStackTrace();
    }
  }

  private String getMobileNumber() {
    if (editText.isEmpty()) {
      return null;
    }
    return String.format("%s%s", textCountryCode.getText().toString(), editText.getString().trim());
  }
}
