/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.util;

import android.util.Log;
import com.zoyi.channel.plugin.android.ChannelPlugin;

public class L {
    public static String TAG = "ChannelPlugin";

    private static void write(Type type, String message) {
        if (message == null || message.equals("")) {
            return;
        }
        int level = 4;
        String fullClassName = Thread.currentThread().getStackTrace()[level].getClassName();
        String className = fullClassName.substring(fullClassName.lastIndexOf(".") + 1).split("$")[0];
        String methodName = Thread.currentThread().getStackTrace()[level].getMethodName();
        int lineNumber = Thread.currentThread().getStackTrace()[level].getLineNumber();
        String tag = String.format("%s %s.%s(%d):", TAG, className, methodName, lineNumber);
        switch (type) {
            case Debug: {
                Log.d((String)tag, (String)message);
                break;
            }
            case Warning: {
                Log.w((String)tag, (String)message);
                break;
            }
            case Error: {
                Log.e((String)tag, (String)message);
                break;
            }
            case Info: {
                Log.i((String)tag, (String)message);
                break;
            }
            case Verbose: {
                Log.v((String)tag, (String)message);
            }
        }
    }

    public static void w(String message) {
        L.write(Type.Warning, message);
    }

    public static void e(String message) {
        L.write(Type.Error, message);
    }

    public static void i(String message) {
        if (!ChannelPlugin.isDebugMode()) {
            return;
        }
        L.write(Type.Info, message);
    }

    public static void d(String message) {
        if (!ChannelPlugin.isDebugMode()) {
            return;
        }
        L.write(Type.Debug, message);
    }

    public static void v(String message) {
        if (!ChannelPlugin.isDebugMode()) {
            return;
        }
        L.write(Type.Verbose, message);
    }

    public static void track(String trackId, String message) {
        L.write(Type.Info, String.format("Track:%s %s", trackId, message));
    }

    private static enum Type {
        Debug,
        Warning,
        Error,
        Info,
        Verbose;

    }
}

