/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.internal.operators.DeferredScalarSubscriber;

public final class OnSubscribeTakeLastOne<T>
implements Observable.OnSubscribe<T> {
    final Observable<T> source;

    public OnSubscribeTakeLastOne(Observable<T> source) {
        this.source = source;
    }

    @Override
    public void call(Subscriber<? super T> t) {
        new TakeLastOneSubscriber<T>(t).subscribeTo(this.source);
    }

    static final class TakeLastOneSubscriber<T>
    extends DeferredScalarSubscriber<T, T> {
        static final Object EMPTY = new Object();

        public TakeLastOneSubscriber(Subscriber<? super T> actual) {
            super(actual);
            this.value = EMPTY;
        }

        @Override
        public void onNext(T t) {
            this.value = t;
        }

        @Override
        public void onCompleted() {
            Object o = this.value;
            if (o == EMPTY) {
                this.complete();
            } else {
                this.complete(o);
            }
        }
    }
}

