package com.zoyi.channel.plugin.android.activity.settings;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.settings.edit.EditNameActivity;
import com.zoyi.channel.plugin.android.activity.settings.edit.EditMobileNumberActivity;
import com.zoyi.channel.plugin.android.global.Const;

public class SettingsInfoFragment extends Fragment implements View.OnClickListener {

  private Context context;

  private TextView textUserName, textUserMobileNumber;

  @Nullable
  @Override
  public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
    return inflater.inflate(R.layout.ch_plugin_fragment_settings_info, container, false);
  }

  @Override
  public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
    super.onViewCreated(view, savedInstanceState);

    context = getContext();

    textUserName = (TextView) view.findViewById(R.id.tv_user_name);
    textUserMobileNumber = (TextView) view.findViewById(R.id.tv_user_mobile_number);

    textUserName.setText(ChannelStore.getName());
    textUserName.setOnClickListener(this);
    textUserMobileNumber.setText(ChannelStore.getMobileNumber());
    textUserMobileNumber.setOnClickListener(this);
  }

  @Override
  public void onActivityResult(int requestCode, int resultCode, Intent data) {
    if (resultCode == Activity.RESULT_OK) {
      switch (requestCode) {
        case Const.REQUEST_EDIT_USER_PROFILE:
          textUserName.setText(ChannelStore.getName());
          textUserMobileNumber.setText(ChannelStore.getMobileNumber());
          break;

        default:
          super.onActivityResult(requestCode, resultCode, data);
      }
    }
  }

  @Override
  public void onClick(View v) {
    int id = v.getId();
    if (id == R.id.tv_user_name) {
      startProfileEditActivity(textUserName.getText().toString(), EditNameActivity.class);
    }
    if (id == R.id.tv_user_mobile_number) {
      startProfileEditActivity(textUserMobileNumber.getText().toString(), EditMobileNumberActivity.class);
    }
  }

  private void startProfileEditActivity(String inputValue, Class<?> clazz) {
    Intent intent = new Intent(context, clazz);

    intent.putExtra(Const.EXTRA_INPUT_VALUE, inputValue);
    startActivityForResult(intent, Const.REQUEST_EDIT_USER_PROFILE);
  }
}
