/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx;

import com.zoyi.rx.Completable;
import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.annotations.Experimental;
import com.zoyi.rx.functions.Action0;
import com.zoyi.rx.functions.Func1;
import com.zoyi.rx.internal.schedulers.SchedulerWhen;
import com.zoyi.rx.internal.subscriptions.SequentialSubscription;
import java.util.concurrent.TimeUnit;

public abstract class Scheduler {
    static final long CLOCK_DRIFT_TOLERANCE_NANOS = TimeUnit.MINUTES.toNanos(Long.getLong("com.zoyi.rx.scheduler.drift-tolerance", 15L));

    public abstract Worker createWorker();

    public long now() {
        return System.currentTimeMillis();
    }

    @Experimental
    public <S extends Scheduler> S when(Func1<Observable<Observable<Completable>>, Completable> combine) {
        return (S)new SchedulerWhen(combine, this);
    }

    public static abstract class Worker
    implements Subscription {
        public abstract Subscription schedule(Action0 var1);

        public abstract Subscription schedule(Action0 var1, long var2, TimeUnit var4);

        public Subscription schedulePeriodically(final Action0 action, long initialDelay, long period, TimeUnit unit) {
            final long periodInNanos = unit.toNanos(period);
            final long firstNowNanos = TimeUnit.MILLISECONDS.toNanos(this.now());
            final long firstStartInNanos = firstNowNanos + unit.toNanos(initialDelay);
            SequentialSubscription first = new SequentialSubscription();
            final SequentialSubscription mas = new SequentialSubscription(first);
            Action0 recursiveAction = new Action0(){
                long count;
                long lastNowNanos;
                long startInNanos;
                {
                    this.lastNowNanos = firstNowNanos;
                    this.startInNanos = firstStartInNanos;
                }

                @Override
                public void call() {
                    action.call();
                    if (!mas.isUnsubscribed()) {
                        long nextTick;
                        long nowNanos = TimeUnit.MILLISECONDS.toNanos(Worker.this.now());
                        if (nowNanos + CLOCK_DRIFT_TOLERANCE_NANOS < this.lastNowNanos || nowNanos >= this.lastNowNanos + periodInNanos + CLOCK_DRIFT_TOLERANCE_NANOS) {
                            nextTick = nowNanos + periodInNanos;
                            this.startInNanos = nextTick - periodInNanos * ++this.count;
                        } else {
                            nextTick = this.startInNanos + ++this.count * periodInNanos;
                        }
                        this.lastNowNanos = nowNanos;
                        long delay = nextTick - nowNanos;
                        mas.replace(Worker.this.schedule(this, delay, TimeUnit.NANOSECONDS));
                    }
                }
            };
            first.replace(this.schedule(recursiveAction, initialDelay, unit));
            return mas;
        }

        public long now() {
            return System.currentTimeMillis();
        }
    }
}

