/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.presenter.userchat;

import android.app.ProgressDialog;
import android.content.Context;
import android.text.TextUtils;
import com.zoyi.channel.plugin.android.ChannelPlugin;
import com.zoyi.channel.plugin.android.activity.userchat_list.OnUserChatCheckListener;
import com.zoyi.channel.plugin.android.activity.userchat_list.OnUserChatClickListener;
import com.zoyi.channel.plugin.android.activity.userchat_list.UserChatCounter;
import com.zoyi.channel.plugin.android.enumerate.Command;
import com.zoyi.channel.plugin.android.enumerate.userchat.UserChatListState;
import com.zoyi.channel.plugin.android.event.ChatCounterBus;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.model.rest.ChannelModel;
import com.zoyi.channel.plugin.android.model.rest.Session;
import com.zoyi.channel.plugin.android.model.source.userchat.UserChatDataSource;
import com.zoyi.channel.plugin.android.model.source.userchat.UserChatRepository;
import com.zoyi.channel.plugin.android.model.wrapper.UserChatWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.UserChatsWrapper;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.presenter.userchat.UserChatAdapterContract;
import com.zoyi.channel.plugin.android.presenter.userchat.UserChatContract;
import com.zoyi.channel.plugin.android.socket.SocketManager;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.ProgressHelper;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.schedulers.Schedulers;

public class UserChatPresenter
implements UserChatContract.Presenter,
OnUserChatClickListener,
OnUserChatCheckListener {
    private UserChatContract.View userchatView;
    private UserChatAdapterContract.View adapterView;
    private UserChatAdapterContract.Model adapterModel;
    private UserChatRepository userChatRepository;
    private Context context;
    private ProgressDialog dialog;
    private UserChatCounter userChatCounter;
    private UserChatListState state = UserChatListState.WAITING_SOCKET;
    private boolean init = true;
    private String runningChatId;

    public UserChatPresenter(Context context) {
        this.context = context;
        this.userChatRepository = new UserChatRepository(new UserChatDataSource());
        this.userChatCounter = new UserChatCounter();
    }

    @Override
    public void showProgress(String message) {
        if (this.dialog == null || !this.dialog.isShowing()) {
            this.dialog = ProgressHelper.show(this.context, ResUtils.getString(this.context, "ch.loading_information"));
        }
    }

    @Override
    public void showProgress() {
        this.showProgress(ResUtils.getString(this.context, "ch.loading_information"));
    }

    @Override
    public void hideProgress() {
        if (this.dialog != null && this.dialog.isShowing()) {
            this.dialog.dismiss();
        }
    }

    @Override
    public void setView(UserChatContract.View view) {
        this.userchatView = view;
    }

    @Override
    public void setAdapterView(UserChatAdapterContract.View adapterView) {
        this.adapterView = adapterView;
        this.adapterView.setOnUserChatClickListener(this);
        this.adapterView.setOnUserChatCheckListener(this);
    }

    @Override
    public void setAdapterModel(UserChatAdapterContract.Model adapterModel) {
        this.adapterModel = adapterModel;
    }

    @Override
    public void setRunningChatId(String runningChatId) {
        this.runningChatId = runningChatId;
    }

    @Override
    public int getChatCount(String chatId) {
        return this.userChatCounter.getCounter(chatId);
    }

    @Override
    public void refresh() {
        switch (this.state) {
            case WAITING_SOCKET: {
                SocketManager.connect();
                break;
            }
            case USER_CHAT_LIST_NOT_LOADED: {
                this.getUserChats();
            }
        }
    }

    @Override
    public void setState(UserChatListState state) {
        this.state = state;
    }

    @Override
    public void getUserChats() {
        if (SocketManager.isReady()) {
            if (this.init) {
                this.showProgress();
            }
            this.userchatView.setReconnectVisibility(false);
            this.setState(UserChatListState.USER_CHAT_LIST_LOADING);
            this.userchatView.setRefreshVisibility(false);
            this.fetchUserChats();
        } else {
            this.setState(UserChatListState.WAITING_SOCKET);
            this.userchatView.setRefreshVisibility(false);
            SocketManager.reconnect();
        }
    }

    @Override
    public void receiveCommand(Command command, Object object) {
        switch (command) {
            case READY: {
                this.userchatView.setReconnectVisibility(false);
                if (UserChatListState.WAITING_SOCKET.equals((Object)this.state)) {
                    this.getUserChats();
                    break;
                }
                this.refresh();
                break;
            }
            case JOINED: {
                this.runningChatId = (String)object;
                break;
            }
            case SOCKET_DISCONNECTED: {
                this.setState(UserChatListState.WAITING_SOCKET);
                this.userchatView.setRefreshVisibility(true);
                this.adapterModel.stopRefreshBySocket();
                break;
            }
            case SOCKET_ERROR: {
                this.userchatView.setReconnectVisibility(true);
            }
        }
    }

    @Override
    public void receiveData(ChannelModel channelModel, boolean upsert) {
        this.adapterModel.receiveChannelModel(channelModel, upsert);
        if (channelModel instanceof Session) {
            Session session = (Session)channelModel;
            if (!CompareUtils.exists((Comparable)((Object)session.getPersonType()), (Comparable[])new String[]{"User", "Veil"})) {
                return;
            }
            if (upsert) {
                this.userChatCounter.upsert(session);
            } else {
                this.userChatCounter.delete(session);
            }
            if (session.getId() != null && !CompareUtils.isSame(session.getChatId(), this.runningChatId)) {
                RxBus.post(new ChatCounterBus(this.userChatCounter.getCounter(this.runningChatId)));
            }
        }
    }

    private void fetchUserChats() {
        this.userChatRepository.getUserChats(new RestSubscriber<UserChatsWrapper>(){

            @Override
            public void onError(RetrofitException error) {
                UserChatPresenter.this.hideProgress();
                UserChatPresenter.this.handleError();
            }

            @Override
            public void onNext(UserChatsWrapper userChatsWrapper) {
                UserChatPresenter.this.hideProgress();
                if (userChatsWrapper == null) {
                    UserChatPresenter.this.handleError();
                } else {
                    UserChatPresenter.this.init = false;
                    UserChatPresenter.this.setState(UserChatListState.READY);
                    UserChatPresenter.this.userchatView.setRefreshVisibility(false);
                    UserChatPresenter.this.adapterModel.init(userChatsWrapper);
                    UserChatPresenter.this.userChatCounter.setList(userChatsWrapper.getSessions());
                    RxBus.post(new ChatCounterBus(UserChatPresenter.this.userChatCounter.getCounter(UserChatPresenter.this.runningChatId)));
                    UserChatPresenter.this.userchatView.userChatsFetched(userChatsWrapper);
                }
            }
        });
    }

    public void handleError() {
        if (UserChatListState.USER_CHAT_LIST_LOADING.equals((Object)this.state)) {
            this.setState(UserChatListState.USER_CHAT_LIST_NOT_LOADED);
            this.userchatView.setRefreshVisibility(true);
        }
    }

    @Override
    public void requestDeleteChat(String chatId) {
        this.showProgress(ResUtils.getString(this.context, "ch.chat.delete_progress"));
        ChannelPlugin.getApi().closeUserChat(chatId).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new RestSubscriber<UserChatWrapper>(){

            @Override
            public void onError(RetrofitException error) {
                UserChatPresenter.this.requestDeleteChats();
            }

            @Override
            public void onNext(UserChatWrapper userChatWrapper) {
                if (userChatWrapper != null) {
                    UserChatPresenter.this.userChatCounter.delete(userChatWrapper.getSession());
                    UserChatPresenter.this.adapterView.removeUserChat(userChatWrapper.getUserChat());
                }
                UserChatPresenter.this.requestDeleteChats();
            }
        });
    }

    @Override
    public void requestDeleteChats() {
        if (this.adapterModel.hasCheckedChatIds()) {
            this.requestDeleteChat(this.adapterModel.getCheckedChatId());
        } else {
            this.userchatView.completeDeleteChat();
        }
    }

    @Override
    public void setEditMode(boolean editMode) {
        this.adapterModel.clearCheckedChatId();
        this.adapterView.setEditMode(editMode);
    }

    @Override
    public void onUserChatClick(String chatId) {
        if (!TextUtils.isEmpty((CharSequence)chatId)) {
            this.runningChatId = chatId;
            this.userchatView.startChat(chatId, this.userChatCounter.getCounter(chatId), false);
        }
    }

    @Override
    public void onUserChatLongClick(String chatId) {
        if (!TextUtils.isEmpty((CharSequence)chatId)) {
            this.userchatView.deleteChat(chatId);
        }
    }

    @Override
    public void onUserChatCheck(String chatId) {
        if (!TextUtils.isEmpty((CharSequence)chatId)) {
            this.adapterView.checkUserChat(chatId);
            this.userchatView.checkUserChat(this.adapterModel.hasCheckedChatIds());
        }
    }
}

