package com.zoyi.channel.plugin.android.push;

import android.app.Notification;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.support.v4.app.NotificationCompat;
import android.text.TextUtils;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.global.Const;

public class NotificationFactory {

  private static final int MAX_CONTENT_TEXT_LENGTH = 20;

  static Notification createPushMessage(Context context, PushData pushData) {
    NotificationCompat.Builder builder = createBuilder(context, pushData);

    if (builder == null) {
      return null;
    }
    return builder.build();
  }

  private static NotificationCompat.Builder createBuilder(Context context, PushData pushData) {
    ComponentName componentName = new ComponentName(context, ChannelBroadcastReceiver.class);
    Intent clickIntent = new Intent(ChannelBroadcastReceiver.ACTION_CHANNEL_PLUGIN_PUSH_CLICK);
    clickIntent.setComponent(componentName);
    clickIntent.putExtra(Const.EXTRA_HOST_APP_INTENT, getHostAppIntent(context, pushData));

    PendingIntent pendingIntent = PendingIntent.getBroadcast(
        context,
        Const.REQUEST_PUSH_MESSAGE,
        clickIntent,
        PendingIntent.FLAG_UPDATE_CURRENT);

    String title = context.getString(R.string.notification_title);
    String message = pushData.getMessage();

    if (TextUtils.isEmpty(message)) {
      return null;
    } else {
      NotificationCompat.Builder builder = new NotificationCompat.Builder(context)
          .setSmallIcon(R.drawable.ch_push_icon)
          .setLargeIcon(BitmapFactory.decodeResource(context.getResources(), R.drawable.ch_push_large_icon))
          .setContentTitle(title)
          .setContentText(message)
          .setContentIntent(pendingIntent)
          .setAutoCancel(true)
          .setDefaults(Notification.DEFAULT_LIGHTS);

      if (Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.LOLLIPOP) {
        builder.setCategory(Notification.CATEGORY_MESSAGE)
            .setPriority(Notification.PRIORITY_HIGH)
            .setVisibility(Notification.VISIBILITY_PUBLIC);
      }

      if (message.length() > MAX_CONTENT_TEXT_LENGTH) {
        builder.setStyle(getBigTextStyle(title, message));
      }

      return builder;
    }
  }

  private static Intent getHostAppIntent(Context context, PushData pushData) {
    Intent hostAppIntent = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());

    if (hostAppIntent == null) {
      hostAppIntent = new Intent();
    } else {
      hostAppIntent.addCategory(Intent.CATEGORY_LAUNCHER);
      hostAppIntent.putExtra(Const.EXTRA_CHAT_ID, pushData.getChatId());
    }

    return hostAppIntent;
  }

  private static NotificationCompat.BigTextStyle getBigTextStyle(String title, String message) {
    return new NotificationCompat.BigTextStyle()
        .bigText(message)
        .setSummaryText(title);
  }

}
