/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.handler;

import android.graphics.PointF;
import android.support.v7.widget.RecyclerView;
import android.view.MotionEvent;
import android.view.View;
import android.widget.EditText;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity;

public class BackgroundToucher
implements View.OnTouchListener {
    private BaseActivity baseActivity;
    private EditText editText;
    private PointF touchPoint = null;

    public static BackgroundToucher makeKeyboardEvent(BaseActivity baseActivity, RecyclerView recyclerView, EditText editText) {
        return new BackgroundToucher(baseActivity, recyclerView, editText);
    }

    private BackgroundToucher(BaseActivity baseActivity, RecyclerView recyclerView, EditText editText) {
        this.baseActivity = baseActivity;
        this.editText = editText;
        recyclerView.setOnTouchListener((View.OnTouchListener)this);
    }

    public boolean onTouch(View v, MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.touchPoint = new PointF(event.getX(), event.getY());
                break;
            }
            case 2: {
                break;
            }
            case 1: {
                if (this.touchPoint != null) {
                    float x = event.getX();
                    float y = event.getY();
                    if (Math.max(Math.abs(x - this.touchPoint.x), Math.abs(y - this.touchPoint.y)) < 10.0f) {
                        this.baseActivity.hideKeyboard(this.editText);
                    }
                }
                this.touchPoint = null;
                break;
            }
            case 3: {
                this.touchPoint = null;
            }
        }
        return false;
    }
}

