/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.lib;

import android.content.Context;
import android.content.DialogInterface;
import android.support.annotation.NonNull;
import android.support.v7.app.AlertDialog;
import com.zoyi.channel.plugin.android.activity.chat.CountryDictionary;
import java.util.ArrayList;
import java.util.List;

public class CountryCodeDialog
extends AlertDialog.Builder {
    private CountryDictionary countryDictionary;
    private String selectedCode;
    private int checkedItem = -1;

    public CountryCodeDialog(@NonNull Context context, String selectedCode, final OnCountryCodeSelectListener listener) {
        super(context);
        this.selectedCode = selectedCode;
        this.countryDictionary = new CountryDictionary(context);
        this.setSingleChoiceItems(this.getItems(), this.checkedItem, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (listener != null) {
                    listener.onCountryCodeSelected(CountryCodeDialog.this.countryDictionary.getCode(which));
                }
                dialog.dismiss();
            }
        });
    }

    private String[] getItems() {
        ArrayList<String> items = new ArrayList<String>();
        List<String> countryNames = this.countryDictionary.getCountryNames();
        for (int i = 0; i < countryNames.size(); ++i) {
            String countryName = countryNames.get(i);
            String code = this.countryDictionary.getCode(i);
            if (this.selectedCode.contains(code)) {
                this.checkedItem = i;
            }
            items.add(String.format("%s (+%s)", countryName, code));
        }
        return items.toArray(new String[items.size()]);
    }

    public static interface OnCountryCodeSelectListener {
        public void onCountryCodeSelected(String var1);
    }
}

