package com.zoyi.channel.plugin.android.model.rest;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by mika on 2016. 12. 6..
 */
public class UserChat implements ChannelModel, UpdatedModel {
  private String id;
  private String channelId;
  private String personType;
  private String personId;
  private String referId;
  private String state;
  private Long createdAt;
  private Long updatedAt;
  private String lastMessageId;
  private String openedAt;
  private Long notifiedAt;
  private Boolean alert;
  private Boolean unread;
  private List<String> talkedManagerIds;

  public String getId() {
    return id;
  }

  public String getChannelId() {
    return channelId;
  }

  public String getPersonType() {
    return personType;
  }

  public String getPersonId() {
    return personId;
  }

  public String getReferId() {
    return referId;
  }

  public String getState() {
    return state;
  }

  public Long getCreatedAt() {
    return createdAt;
  }

  public Long getUpdatedAt() {
    return updatedAt;
  }

  public String getLastMessageId() {
    return lastMessageId;
  }

  public String getOpenedAt() {
    return openedAt;
  }

  public Long getNotifiedAt() {
    return notifiedAt;
  }

  public Boolean getAlert() {
    return alert;
  }

  public Boolean getUnread() {
    return unread;
  }

  public List<String> getTalkedManagerIds() {
    if (talkedManagerIds == null) {
      return new ArrayList<>();
    }
    return talkedManagerIds;
  }

  public String getSessionId() {
    return String.format("%s:%s", channelId, id);
  }

  public final static String CLASSNAME = "UserChat";
}
