/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mint;

import android.content.Context;
import android.content.SharedPreferences;
import com.splunk.mint.Logger;
import com.splunk.mint.Properties;
import com.splunk.mint.RemoteSettingsData;
import org.json.JSONObject;

class RemoteSettings {
    private static final String SHARED_PREFERENSES_NAME = "REMOTESETTINGSSETTINGS";
    private static final String REMOTESETTINGS_API = "1";
    private static final String REMOTESETTINGS_NAME = "remSetVer";
    private static final String LOGLEVEL = "logLevel";
    private static final String EVENTLEVEL = "eventLevel";
    private static final String NETWORKMONITORING = "netMonitoring";
    private static final String SESSIONTIME = "sessionTime";
    private static final String HASHCODE = "hashCode";
    private static final String DEVSETTINGS = "devSettings";

    RemoteSettings() {
    }

    protected static final RemoteSettingsData convertJsonToRemoteSettings(String jsonData) {
        if (jsonData == null || jsonData.length() < 1) {
            return null;
        }
        RemoteSettingsData rsd = new RemoteSettingsData();
        try {
            JSONObject rdjson = new JSONObject(jsonData);
            JSONObject settings = rdjson.optJSONObject("remSetVer1");
            if (settings != null) {
                rsd.logLevel = settings.optInt(LOGLEVEL);
                rsd.eventLevel = settings.optInt(EVENTLEVEL);
                rsd.netMonitoring = settings.optBoolean(NETWORKMONITORING);
                rsd.sessionTime = settings.optInt(SESSIONTIME);
                if (settings.optJSONObject(DEVSETTINGS) != null) {
                    rsd.devSettings = settings.optJSONObject(DEVSETTINGS).toString();
                }
                rsd.hashCode = settings.optString("hash");
            }
        }
        catch (Exception e) {
            Logger.logError("Could not convert json to remote data");
            Logger.logInfo(e.getMessage());
            return null;
        }
        return rsd;
    }

    protected static final void saveAndLoadRemoteSettings(Context ctx, RemoteSettingsData rsd) {
        SharedPreferences preferences = ctx.getSharedPreferences(SHARED_PREFERENSES_NAME, 0);
        if (preferences == null) {
            return;
        }
        SharedPreferences.Editor editor = preferences.edit();
        if (editor == null) {
            return;
        }
        try {
            if (rsd.logLevel != null && rsd.logLevel > 0) {
                editor.putInt(LOGLEVEL, rsd.logLevel.intValue());
                Properties.RemoteSettingsProps.logLevel = rsd.logLevel;
            }
            if (rsd.eventLevel != null && rsd.eventLevel > 0) {
                editor.putInt(EVENTLEVEL, rsd.eventLevel.intValue());
                Properties.RemoteSettingsProps.eventLevel = rsd.eventLevel;
            }
            if (rsd.netMonitoring != null) {
                editor.putBoolean(NETWORKMONITORING, rsd.netMonitoring.booleanValue());
                Properties.RemoteSettingsProps.netMonitoringEnabled = rsd.netMonitoring;
            }
            if (rsd.sessionTime != null && rsd.sessionTime > 0) {
                editor.putInt(SESSIONTIME, rsd.sessionTime.intValue());
                Properties.RemoteSettingsProps.sessionTime = rsd.sessionTime;
            }
            if (rsd.devSettings != null) {
                editor.putString(DEVSETTINGS, rsd.devSettings);
                Properties.RemoteSettingsProps.devSettings = new JSONObject(rsd.devSettings);
            }
            if (rsd.hashCode != null && rsd.hashCode.length() > 1) {
                editor.putString(HASHCODE, rsd.hashCode);
                Properties.RemoteSettingsProps.hashCode = rsd.hashCode;
            }
        }
        catch (Exception e) {
            Logger.logError("Could not save remote data");
            Logger.logInfo(e.getMessage());
        }
        editor.apply();
    }

    protected static final RemoteSettingsData loadRemoteSettings(Context ctx) {
        RemoteSettingsData rsd = new RemoteSettingsData();
        SharedPreferences preferences = ctx.getSharedPreferences(SHARED_PREFERENSES_NAME, 0);
        if (preferences == null) {
            return null;
        }
        rsd.logLevel = preferences.getInt(LOGLEVEL, Properties.RemoteSettingsProps.logLevel.intValue());
        if (rsd.logLevel == null) {
            rsd.logLevel = Properties.RemoteSettingsProps.logLevel;
        }
        rsd.eventLevel = preferences.getInt(EVENTLEVEL, Properties.RemoteSettingsProps.eventLevel.intValue());
        if (rsd.eventLevel == null) {
            rsd.eventLevel = Properties.RemoteSettingsProps.eventLevel;
        }
        rsd.netMonitoring = preferences.getBoolean(NETWORKMONITORING, Properties.RemoteSettingsProps.netMonitoringEnabled.booleanValue());
        if (rsd.netMonitoring == null) {
            rsd.netMonitoring = Properties.RemoteSettingsProps.netMonitoringEnabled;
        }
        rsd.sessionTime = preferences.getInt(SESSIONTIME, Properties.RemoteSettingsProps.sessionTime.intValue());
        if (rsd.sessionTime == null) {
            rsd.sessionTime = Properties.RemoteSettingsProps.sessionTime;
        }
        rsd.devSettings = preferences.getString(DEVSETTINGS, Properties.RemoteSettingsProps.devSettings.toString());
        if (rsd.devSettings == null) {
            rsd.devSettings = Properties.RemoteSettingsProps.devSettings.toString();
        }
        rsd.hashCode = preferences.getString(HASHCODE, Properties.RemoteSettingsProps.hashCode);
        if (rsd.hashCode == null) {
            rsd.hashCode = Properties.RemoteSettingsProps.hashCode;
        }
        return rsd;
    }
}

