package com.zoyi.channel.plugin.android.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;

import java.net.NetworkInterface;
import java.util.Collections;
import java.util.List;

/**
 * Created by mika on 2018. 7. 4..
 */

public class DeviceUtils {

  @SuppressLint("HardwareIds")
  public static String getWId(Context context) {
    try {
      // First, check sdk version
      if (Build.VERSION.SDK_INT < Build.VERSION_CODES.M) {
        if (context != null && context.getApplicationContext() != null) {
          WifiManager manager = (WifiManager) context.getApplicationContext().getSystemService(Context.WIFI_SERVICE);
          if (manager != null) {
            WifiInfo wifiInfo = manager.getConnectionInfo();

            if (wifiInfo != null &&
                wifiInfo.getMacAddress() != null &&
                !"02:00:00:00:00:00".equals(wifiInfo.getMacAddress())) {
              return manager.getConnectionInfo().getMacAddress();
            }
          }
        }
      }

      // if mac address is invalid, check another route
      List<NetworkInterface> interfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
      String interfaceName = "wlan0";

      for (NetworkInterface networkInterface : interfaces) {
        if (!networkInterface.getName().equalsIgnoreCase(interfaceName)) {
          continue;
        }
        byte[] mac = networkInterface.getHardwareAddress();
        if (mac == null) {
          return null;
        }
        StringBuilder buf = new StringBuilder();
        for (byte aMac : mac) {
          buf.append(String.format("%02X:", aMac));
        }
        if (buf.length() > 0) {
          buf.deleteCharAt(buf.length() - 1);
        }
        return buf.toString().trim();
      }
    } catch (Exception ignored) {
    }
    return null;
  }
}
