package com.zoyi.channel.plugin.android.util;

import android.content.Context;
import android.support.annotation.Nullable;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.io.InputStream;

/**
 * Created by jerry on 2018. 3. 27..
 */

public class AssetUtils {
  private static final String EMOJI_DICTIONARY = "emoji_dictionary.json";

  @Nullable
  public static JSONObject getEmojiDictionary(Context context) {
    JSONObject emojiDictionary;
    try {
      InputStream inputStream = context.getAssets().open(EMOJI_DICTIONARY);
      int size = inputStream.available();
      byte[] buffer = new byte[size];

      inputStream.read(buffer);
      inputStream.close();

      emojiDictionary = new JSONObject(new String(buffer, "UTF-8"));

    } catch (IOException ioError) {
      L.e(ioError.toString());
      return null;
    } catch (JSONException JsonError) {
      L.e(JsonError.toString());
      return null;
    }

    return emojiDictionary;
  }
}
