/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.util.message_format.message;

import android.text.SpannableStringBuilder;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.message_format.message.EscapeMessage;
import com.zoyi.channel.plugin.android.util.message_format.message.MessagePattern;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UnescapeMessage
implements MessagePattern {
    private Pattern unescapePattern = Pattern.compile(EscapeMessage.ESCAPE_PREFIX + "[\\d]+" + EscapeMessage.ESCAPE_POSTFIX);

    @Override
    public SpannableStringBuilder parse(SpannableStringBuilder span) {
        Matcher matcher = this.unescapePattern.matcher((CharSequence)span);
        while (matcher.find()) {
            try {
                int start = matcher.start();
                int end = matcher.end();
                String plainText = span.toString();
                String escape = this.asciiToString(plainText.substring(start + EscapeMessage.ESCAPE_PREFIX.length(), end - EscapeMessage.ESCAPE_POSTFIX.length()));
                span.delete(start, end);
                span.insert(start, (CharSequence)escape);
                matcher = this.unescapePattern.matcher((CharSequence)span);
            }
            catch (IndexOutOfBoundsException indexException) {
                L.e(indexException.getMessage());
                return span;
            }
        }
        return span;
    }

    private String asciiToString(String ascii) {
        int asciiNum = Integer.decode(ascii);
        String asciiChar = Character.toString((char)asciiNum);
        return asciiChar;
    }
}

