package com.zoyi.channel.plugin.android.model.wrapper;

import com.zoyi.channel.plugin.android.model.rest.*;
import com.zoyi.channel.plugin.android.store.*;

/**
 * Created by mika on 2016. 12. 6..
 */
public class PluginWrapper extends BaseRepo {
  private Plugin plugin;
  private Channel channel;
  private User user;
  private Veil veil;
  private String veilId;
  private Bot bot;

  public Plugin getPlugin() {
    return plugin;
  }

  public Channel getChannel() {
    return channel;
  }

  public User getUser() {
    return user;
  }

  public Veil getVeil() {
    return veil;
  }

  public Bot getBot() {
    return bot;
  }

  public String getVeilId() {
    return veilId;
  }

  @Override
  public void set() {
    Store.getInstance(PluginStore.class).set(plugin);
    Store.getInstance(ChannelStore.class).set(channel);
    Store.getInstance(UserStore.class).set(user);
    Store.getInstance(VeilStore.class).set(veil);
    Store.getInstance(VeilStore.class).setVeilId(veilId);
    Store.getInstance(BotStore.class).add(bot);
    Store.getInstance(BotStore.class).setDefaultBot(bot);
  }

  @Override
  public boolean isValid() {
    return plugin != null && channel != null && !channel.isSdkPluginBlocked() && (user != null || veil != null);
  }
}
