package com.zoyi.channel.plugin.android.activity.chat.model;

import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import com.zoyi.channel.plugin.android.util.CountryUtils;

/**
 * Created by mika on 2018. 4. 17..
 */

public class MobileNumber {
  private int countryCode;
  private String phoneNumber;

  public MobileNumber(String mobileNumber) {
    PhoneNumberUtil phoneUtil = PhoneNumberUtil.getInstance();
    try {
      Phonenumber.PhoneNumber numberProto = phoneUtil.parse(mobileNumber, "");

      this.countryCode = numberProto.getCountryCode();
      this.phoneNumber = phoneUtil.format(numberProto, PhoneNumberUtil.PhoneNumberFormat.NATIONAL).replace("-", "");
    } catch (NumberParseException e) {
      this.countryCode = CountryUtils.getDefaultCountryCodeInt();
      this.phoneNumber = "";
    }
  }

  public MobileNumber(int countryCode, String phoneNumber) {
    this.countryCode = countryCode;
    this.phoneNumber = phoneNumber;
  }

  public int getCountryCode() {
    return countryCode;
  }

  public void setCountryCode(int countryCode) {
    this.countryCode = countryCode;
  }

  public String getPhoneNumber() {
    return phoneNumber;
  }

  public void setPhoneNumber(String phoneNumber) {
    this.phoneNumber = phoneNumber;
  }
}
