package com.zoyi.channel.plugin.android.activity.chat;

import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.activity.chat.model.SendingMessageItem;
import com.zoyi.channel.plugin.android.enumerate.Command;
import com.zoyi.channel.plugin.android.model.entity.Entity;
import com.zoyi.channel.plugin.android.model.entity.Person;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.etc.Typing;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.base.BasePresenter;
import com.zoyi.channel.plugin.android.base.BaseView;

import java.util.ArrayList;

public interface ChatContract {

  interface View extends BaseView<Presenter> {

    void onLoadUserChat(@Nullable UserChat userChat, boolean create);
    void updateBackwardId(@Nullable String backwardId);
    void setInputLayoutVisibility();
    boolean isMovableToBottomPosition();
    boolean isBottomPosition();
    void scrollToBottom(boolean force);
    void scrollToPosition(int position);
    void setRefreshVisibility(boolean showRefresh);
    void processNewMessage(@Nullable ProfileEntity profileEntity, Message message);
    void setPerson(@Nullable Person person);
    void onRemovedChat();
    void onFileDownload(File file);
    void onShowPhotoAlbum(File file);
    void onUrlClicked(String url);
    void sendingMessageClicked(SendingMessageItem item);
    void onChangeProfileMessageFocus(boolean hasFocus);
    void setReconnectVisibility(boolean show);
    void setChannel(Channel channel);
    void changeBigBar();
    void requestFocusEditText();
  }

  interface Presenter extends BasePresenter<View> {

    @Nullable
    UserChat getUserChat();
    @Nullable
    String getChatId();

    boolean isStateCompleted();
    void setChatId(@Nullable String chatId);
    void setAdapterView(ChatAdapterContract.View adapterView);
    void setAdapterModel(ChatAdapterContract.Model adapterModel);
    void requestPreloadData(@Nullable String chatId);
    boolean isMessageExists();
    void fetchForwardMessages(String since, final int count);
    void fetchBackwardMessages();
    void sendTextMessage(String message);
    void sendImageFiles(ArrayList<String> imagePaths);
    void receiveData(Entity entity, boolean upsert);
    void receiveCommand(Command command, @Nullable Object object);
    void receiveTyping(Typing typing);
    void receiveLanguageEvent();
    void resend(SendingMessageItem item);
    void removeFailedItem(SendingMessageItem item);
    void refresh();
    void leaveChat();
  }

}
