package com.zoyi.channel.plugin.android;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.activity.base.BaseActivity;
import com.zoyi.channel.plugin.android.activity.userchat_list.UserChatListActivity;
import com.zoyi.channel.plugin.android.enumerate.Command;
import com.zoyi.channel.plugin.android.event.CommandBus;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.socket.SocketManager;
import com.zoyi.channel.plugin.android.util.L;

public class ActivityLifecycleManager implements Application.ActivityLifecycleCallbacks {

  @Nullable
  private Activity startedActivity;
  private int running = 0;

  @Override
  public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    L.d("onStart: " + activity.getClass().getSimpleName());
  }

  @Override
  public void onActivityStarted(Activity activity) {
    L.d("Started: " + activity.getClass().getSimpleName() + " " + running + " -> " + (running + 1));
    startedActivity = activity;
    if (++running == 1) {
      RxBus.post(new CommandBus(Command.APP_STARTED));
      SocketManager.connect();
    }
  }

  @Override
  public void onActivityResumed(Activity activity) {
  }

  @Override
  public void onActivityPaused(Activity activity) {
  }

  @Override
  public void onActivityStopped(Activity activity) {
    L.d("Stopped: " + activity.getClass().getSimpleName() + " " + running + " -> " + (running - 1));
    if (--running == 0) {
      SocketManager.disconnect();
      RxBus.post(new CommandBus(Command.APP_STOPPED));
    }
  }

  @Override
  public void onActivitySaveInstanceState(Activity activity, Bundle outState) {

  }

  @Override
  public void onActivityDestroyed(Activity activity) {
    L.d("onDestroy: " + activity.getClass().getSimpleName());
    if (activity instanceof UserChatListActivity) {
      for (ChannelPluginListener l : ChannelIOManager.getChannelPluginListeners()) {
        if (l != null) {
          l.willHideMessenger();
        }
      }
    }
  }

  public void finish(boolean animated) {
    if (startedActivity != null && startedActivity instanceof BaseActivity) {
      startedActivity.setResult(Const.RESULT_ACTIVITY_FINISH);
      ((BaseActivity) startedActivity).finish(animated);
    }
  }
}
