/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.schedulers;

import com.zoyi.rx.Scheduler;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.functions.Action0;
import com.zoyi.rx.internal.subscriptions.SequentialSubscription;
import java.util.concurrent.TimeUnit;

public final class SchedulePeriodicHelper {
    public static final long CLOCK_DRIFT_TOLERANCE_NANOS = TimeUnit.MINUTES.toNanos(Long.getLong("rx.scheduler.drift-tolerance", 15L));

    private SchedulePeriodicHelper() {
        throw new IllegalStateException("No instances!");
    }

    public static Subscription schedulePeriodically(final Scheduler.Worker worker, final Action0 action, long initialDelay, long period, TimeUnit unit, final NowNanoSupplier nowNanoSupplier) {
        final long periodInNanos = unit.toNanos(period);
        final long firstNowNanos = nowNanoSupplier != null ? nowNanoSupplier.nowNanos() : TimeUnit.MILLISECONDS.toNanos(worker.now());
        final long firstStartInNanos = firstNowNanos + unit.toNanos(initialDelay);
        SequentialSubscription first = new SequentialSubscription();
        final SequentialSubscription mas = new SequentialSubscription(first);
        Action0 recursiveAction = new Action0(){
            long count;
            long lastNowNanos;
            long startInNanos;
            {
                this.lastNowNanos = firstNowNanos;
                this.startInNanos = firstStartInNanos;
            }

            public void call() {
                action.call();
                if (!mas.isUnsubscribed()) {
                    long nextTick;
                    long nowNanos;
                    long l = nowNanos = nowNanoSupplier != null ? nowNanoSupplier.nowNanos() : TimeUnit.MILLISECONDS.toNanos(worker.now());
                    if (nowNanos + CLOCK_DRIFT_TOLERANCE_NANOS < this.lastNowNanos || nowNanos >= this.lastNowNanos + periodInNanos + CLOCK_DRIFT_TOLERANCE_NANOS) {
                        nextTick = nowNanos + periodInNanos;
                        this.startInNanos = nextTick - periodInNanos * ++this.count;
                    } else {
                        nextTick = this.startInNanos + ++this.count * periodInNanos;
                    }
                    this.lastNowNanos = nowNanos;
                    long delay = nextTick - nowNanos;
                    mas.replace(worker.schedule(this, delay, TimeUnit.NANOSECONDS));
                }
            }
        };
        first.replace(worker.schedule(recursiveAction, initialDelay, unit));
        return mas;
    }

    public static interface NowNanoSupplier {
        public long nowNanos();
    }
}

