package com.zoyi.channel.plugin.android.activity.userchat_list.model;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.activity.base.SortableItem;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.selector.CounterSelector;
import com.zoyi.channel.plugin.android.selector.MessageSelector;
import com.zoyi.channel.plugin.android.selector.ProfileSelector;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.TimeUtils;

/**
 * Created by mika on 2016. 12. 6..
 */
public class UserChatItem implements SortableItem {
  @Nullable
  private UserChat userChat;

  public UserChatItem(@NonNull UserChat userChat) {
    this.userChat = userChat;
  }

  @Nullable
  public UserChat getUserChat() {
    return userChat;
  }

  public void setUserChat(@Nullable UserChat userChat) {
    if (userChat != null) {
      this.userChat = userChat;
    }
  }

  @NonNull
  public String getId() {
    if (userChat != null && userChat.getId() != null) {
      return userChat.getId();
    }
    return "";
  }

  // UI render methods

  @Nullable
  public ProfileEntity getProfile() {
    if (userChat != null) {
      return ProfileSelector.getHostProfile(userChat.getHostType(), userChat.getHostId());
    }
    return null;
  }

  @NonNull
  public String getHostName(Context context) {
    if (userChat != null) {
      return ProfileSelector.getPersonName(context, userChat.getHostType(), userChat.getHostId());
    }
    return ResUtils.getString(context, Const.UNKNOWN_KEY);
  }

  @Nullable
  public Message getLastMessage() {
    if (userChat != null) {
      return MessageSelector.get(userChat.getLastMessageId());
    }
    return null;
  }

  public String getAlert() {
    return CounterSelector.getChatCounter(getId());
  }

  @NonNull
  public String getUpdatedDate() {
    if (userChat != null) {
      if (userChat.isStateResolved() && userChat.getResolvedAt() != null) {
        return TimeUtils.get(userChat.getResolvedAt());
      }
      if (userChat.getUpdatedAt() != null) {
        return TimeUtils.get(userChat.getUpdatedAt());
      }
    }
    return "";
  }

  @Nullable
  public String getHostType() {
    if (userChat != null) {
      return userChat.getHostType();
    }
    return null;
  }

  @Nullable
  public String getHostId() {
    if (userChat != null) {
      return userChat.getHostId();
    }
    return null;
  }

  // Sortable item methods

  @NonNull
  @Override
  public Long getPrimaryKey() {
    if (userChat != null && userChat.getUpdatedAt() != null) {
      return userChat.getUpdatedAt();
    }
    return 0L;
  }

  @NonNull
  @Override
  public String getSecondaryKey() {
    return getId();
  }
}
