/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.model;

import com.zoyi.channel.plugin.android.activity.chat.model.MessageItem;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;

public class SendingMessageItem
implements MessageItem {
    private String chatId;
    private String requestId;
    private String string;
    private boolean image;
    private boolean sending;
    private Long createdAt;
    private static int count = 0;

    public SendingMessageItem() {
    }

    public SendingMessageItem(String chatId, String string2, boolean image) {
        this.refreshCreatedAt();
        this.chatId = chatId;
        this.string = string2;
        this.image = image;
        this.sending = true;
    }

    @Override
    public Long getFirst() {
        return this.createdAt;
    }

    @Override
    public String getSecond() {
        return this.requestId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    @Override
    public MessageType getType() {
        return MessageType.SENDING;
    }

    public String getChatId() {
        return this.chatId;
    }

    public boolean isSending() {
        return this.sending;
    }

    public void setSending(boolean sending) {
        this.sending = sending;
    }

    public String getString() {
        return this.string;
    }

    public boolean isImage() {
        return this.image;
    }

    public static SendingMessageItem create(String requestId, String channelId, String chatId) {
        if (requestId == null) {
            return null;
        }
        SendingMessageItem message = new SendingMessageItem();
        message.requestId = requestId;
        try {
            message.createdAt = Long.parseLong(requestId);
        }
        catch (Exception ex) {
            return null;
        }
        return message;
    }

    public String getMessage() {
        return this.string;
    }

    public Long getCreatedAt() {
        return this.createdAt;
    }

    public void setChatId(String chatId) {
        this.chatId = chatId;
    }

    public void refreshCreatedAt() {
        long now = System.currentTimeMillis() * 100L + (long)(count % 100);
        this.requestId = String.valueOf(now);
        this.createdAt = now;
        count = (count + 1) % 100;
    }
}

