/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.util;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Point;
import java.util.Locale;

public class Utils {
    public static int addBlackMask(int n2) {
        float[] fArray = new float[3];
        Color.colorToHSV((int)n2, (float[])fArray);
        fArray[2] = Math.max(0.0f, fArray[2] - 0.2f);
        return Color.HSVToColor((float[])fArray);
    }

    public static Point getCorrectImageSize(int n2, int n3, int n4, int n5) {
        double d2 = 1.0;
        double d3 = 1.0;
        int n6 = n4;
        int n7 = n5;
        if (n2 == 0 || n3 == 0) {
            return new Point(n4, n5);
        }
        int n8 = n2 / 10;
        n2 = n2 * 6 / 10;
        int n9 = n3 / 10;
        n3 = n3 * 5 / 10;
        if (n4 > n2) {
            d2 = (double)n2 / (double)n4;
        } else if (n4 < n8) {
            d2 = (double)n8 / (double)n4;
        }
        if (n5 > n3) {
            d3 = (double)n3 / (double)n5;
        } else if (n5 < n8) {
            d3 = (double)n9 / (double)n5;
        }
        if (d2 > 1.0 && d3 < 1.0) {
            return new Point(n8, n3);
        }
        if (d2 < 1.0 && d3 > 1.0) {
            return new Point(n2, n9);
        }
        if (d2 < 1.0) {
            double d4 = Math.min(d2, d3);
            n6 = Math.max(n8, (int)((double)n4 * d4));
            n7 = Math.max(n9, (int)((double)n5 * d4));
        } else if (d2 > 1.0) {
            double d5 = Math.max(d2, d3);
            n6 = Math.min(n2, (int)((double)n4 * d5));
            n7 = Math.min(n3, (int)((double)n5 * d5));
        }
        return new Point(n6, n7);
    }

    public static String getProperBytes(long l2) {
        if (l2 < 1000L) {
            return String.format(Locale.US, "%dB", l2);
        }
        if (l2 <= 1000000L) {
            return String.format(Locale.US, "%.1fKB", (double)l2 / 1000.0);
        }
        if (l2 <= 1000000000L) {
            return String.format(Locale.US, "%.1fMB", (double)l2 / 1000000.0);
        }
        return String.format(Locale.US, "%.1fGB", (double)l2 / 1.0E9);
    }

    public static float dpToPx(Context context, float f2) {
        context = context.getResources();
        context = context.getDisplayMetrics();
        return f2 * ((float)context.densityDpi / 160.0f);
    }

    public static String getCount(int n2, boolean bl) {
        return Utils.getCount((long)n2, bl);
    }

    public static String getCount(long l2, boolean bl) {
        if (l2 <= 0L && bl) {
            return "";
        }
        if (l2 >= 1000L) {
            return "999+";
        }
        return String.valueOf(l2);
    }
}

