package com.zoyi.channel.plugin.android;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by mika on 2017. 1. 24..
 */
public class CheckIn {
  public static CheckIn create() {
    return new CheckIn();
  }

  private String userId, name, avatarUrl, mobileNumber;
  private Map<String, Object> meta;

  public CheckIn() {
    meta = new HashMap<>();
  }

  public CheckIn withUserId(String userId) {
    this.userId = userId;
    return this;
  }

  public CheckIn withName(String name) {
    this.name = name;
    return this;
  }

  public CheckIn withAvatarUrl(String avatarUrl) {
    this.avatarUrl = avatarUrl;
    return this;
  }

  public CheckIn withMobileNumber(String mobileNumber) {
    this.mobileNumber = mobileNumber;
    return this;
  }

//  public CheckIn withMeta(Map<String, String> meta) {
//    this.meta = meta;
//    return this;
//  }

  public CheckIn withMeta(String key, String value) {
    meta.put(key, value);
    return this;
  }

  public CheckIn withMeta(String key, Integer value) {
    meta.put(key, value);
    return this;
  }

  public CheckIn withMeta(String key, Long value) {
    meta.put(key, value);
    return this;
  }

  public CheckIn withMeta(String key, Boolean value) {
    meta.put(key, value);
    return this;
  }

  public String getUserId() {
    return userId;
  }

  public String getName() {
    return name;
  }

  public String getAvatarUrl() {
    return avatarUrl;
  }

  public String getMobileNumber() {
    return mobileNumber;
  }

  public Map<String, Object> getMapMeta() {
    return meta;
  }

  Object getMeta() {
    return meta;
  }
}
