/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.util;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import java.io.Serializable;

public class IntentUtils {
    private Context context;
    private Intent intent;

    public static IntentUtils setNextActivity(Context context, Class<?> clazz) {
        IntentUtils intentUtils = new IntentUtils();
        intentUtils.context = context;
        intentUtils.intent = new Intent(context, clazz);
        return intentUtils;
    }

    public IntentUtils putExtra(String key, Integer value) {
        if (value != null) {
            this.intent.putExtra(key, (Serializable)value);
        }
        return this;
    }

    public IntentUtils putExtra(String key, Long value) {
        if (value != null) {
            this.intent.putExtra(key, (Serializable)value);
        }
        return this;
    }

    public IntentUtils putExtra(String key, String value) {
        if (value != null) {
            this.intent.putExtra(key, value);
        }
        return this;
    }

    public IntentUtils putExtra(String key, Boolean value) {
        if (value != null) {
            this.intent.putExtra(key, (Serializable)value);
        }
        return this;
    }

    public IntentUtils putExtra(String key, Parcelable value) {
        if (value != null) {
            this.intent.putExtra(key, value);
        }
        return this;
    }

    public void startActivity() {
        if (this.context != null && this.intent != null) {
            try {
                this.context.startActivity(this.intent);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void startActivityForResult(int requestCode) {
        if (this.context instanceof Activity) {
            this.intent.putExtra("REQUEST_CODE_INTENT_KEY", requestCode);
            ((Activity)this.context).startActivityForResult(this.intent, requestCode);
        }
    }
}

