/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat;

import android.support.v4.util.LongSparseArray;
import com.zoyi.channel.plugin.android.ChannelPlugin;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnMessageSendListener;
import com.zoyi.channel.plugin.android.activity.chat.model.MessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.SendingMessageItem;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.wrapper.MessageWrapper;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.RequestUtils;
import com.zoyi.retrofit2.okhttp3.MediaType;
import com.zoyi.retrofit2.okhttp3.MultipartBody;
import com.zoyi.retrofit2.okhttp3.RequestBody;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class ChatManager {
    private static ChatManager chatManager;
    private boolean sending = false;
    private boolean released = false;
    private Queue<SendingMessageItem> sendingItems = new LinkedList<SendingMessageItem>();
    private LongSparseArray<SendingMessageItem> failedItems = new LongSparseArray();
    private OnMessageSendListener listener;

    public static ChatManager get() {
        if (chatManager == null) {
            chatManager = new ChatManager();
        }
        return chatManager;
    }

    public void setOnMessageSendListener(OnMessageSendListener listener) {
        this.listener = listener;
    }

    public void removeFailedItem(Long createdAt) {
        if (createdAt != null) {
            this.failedItems.remove(createdAt.longValue());
        }
    }

    public void send(String chatId, List<SendingMessageItem> items) {
        if (!this.released) {
            for (SendingMessageItem item : items) {
                item.setChatId(chatId);
                this.send(item);
            }
        }
    }

    public void send(List<SendingMessageItem> items) {
        if (!this.released) {
            for (SendingMessageItem item : items) {
                this.send(item);
            }
        }
    }

    public void send(SendingMessageItem item) {
        if (!this.released && item != null && item.getCreatedAt() != null) {
            this.removeFailedItem(item.getCreatedAt());
            item.setSending(true);
            this.sendingItems.add(item);
            this.send();
        }
    }

    private void send() {
        if (!this.sending && this.sendingItems.size() > 0) {
            this.sending = true;
            SendingMessageItem item = this.sendingItems.poll();
            if (item.isImage()) {
                this.sendFileMessage(item);
            } else {
                this.sendTextMessage(item);
            }
        }
    }

    private void sendTextMessage(final SendingMessageItem item) {
        RequestBody body = RequestUtils.form().set("message", item.getMessage()).set("requestId", item.getRequestId()).create();
        ChannelPlugin.getApi().sendMessage(item.getChatId(), body).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new RestSubscriber<MessageWrapper>(){

            @Override
            public void onError(RetrofitException error) {
                ChatManager.this.failed(error, item);
            }

            @Override
            public void onNext(MessageWrapper wrapper) {
                ChatManager.this.successed(item, wrapper.getMessage());
            }
        });
    }

    private void sendFileMessage(final SendingMessageItem item) {
        MultipartBody.Part body = RequestUtils.makeMultipart(item.getString());
        RequestBody timestamp = RequestBody.create((MediaType)MediaType.parse((String)"text/plane"), (String)item.getRequestId());
        if (body == null) {
            this.failed(new Exception("Not supported type"), item);
            return;
        }
        ChannelPlugin.getApi().uploadFile(item.getChatId(), body, timestamp).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new RestSubscriber<MessageWrapper>(){

            @Override
            public void onError(RetrofitException error) {
                ChatManager.this.failed(error, item);
            }

            @Override
            public void onNext(MessageWrapper wrapper) {
                ChatManager.this.successed(item, wrapper.getMessage());
            }
        });
    }

    private void successed(SendingMessageItem item, Message message) {
        if (!this.released) {
            if (this.listener != null) {
                this.listener.sendSuccessed(item, message);
            }
            this.sending = false;
            this.send();
        }
    }

    private void failed(Exception ex, SendingMessageItem item) {
        if (ex != null) {
            L.e(ex.getMessage());
        }
        if (!this.released) {
            item.setSending(false);
            this.failedItems.put(item.getCreatedAt().longValue(), (Object)item);
            if (this.listener != null) {
                this.listener.sendFailed(item);
            }
            this.sending = false;
            this.send();
        }
    }

    public List<MessageItem> getFailedItems(String chatId) {
        ArrayList<MessageItem> items = new ArrayList<MessageItem>();
        for (int i = 0; i < this.failedItems.size(); ++i) {
            SendingMessageItem item = (SendingMessageItem)this.failedItems.valueAt(i);
            if (!CompareUtils.isSame(chatId, item.getChatId())) continue;
            items.add(item);
        }
        return items;
    }

    public static void release() {
        if (chatManager != null) {
            ChatManager.chatManager.released = true;
            ChatManager.chatManager.sendingItems.clear();
            ChatManager.chatManager.failedItems.clear();
            chatManager = null;
        }
    }
}

