package com.zoyi.channel.plugin.android.activity.photo_album;

import android.content.Context;
import android.support.v4.view.PagerAdapter;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.view.external.photoview.PhotoView;
import com.zoyi.channel.plugin.android.view.external.photoview.PhotoViewAttacher;
import com.zoyi.com.bumptech.glide.Glide;

import java.util.ArrayList;

public class PhotoAlbumPagerAdapter extends PagerAdapter {

  private Context context;
  private PhotoViewAttacher.OnPhotoTapListener listener;
  private LayoutInflater inflater;
  private ArrayList<File> files;

  public PhotoAlbumPagerAdapter(
      Context context,
      ArrayList<File> files,
      PhotoViewAttacher.OnPhotoTapListener listener) {
    this.context = context;
    inflater = LayoutInflater.from(context);
    this.files = new ArrayList<>();
    this.files.addAll(files);
    this.listener = listener;
  }

  @Override
  public int getCount() {
    return (files != null)? files.size() : 0;
  }

  @Override
  public int getItemPosition(Object item) {
    return POSITION_NONE;
  }

  @Override
  public boolean isViewFromObject(View view, Object object) {
    return view.equals(object);
  }

  @Override
  public void destroyItem(ViewGroup container, int position, Object object) {
    if (container != null && object != null && object instanceof View) {
      container.removeView((View) object);
    }
  }

  @Override
  public Object instantiateItem(ViewGroup container, int position) {
    File file = files.get(position);
    View view = inflater.inflate(R.layout.ch_plugin_activity_photo_album_item, container, false);
    PhotoView photoView = (PhotoView) view.findViewById(R.id.iv_accessary_image);
    photoView.setOnPhotoTapListener(listener);

    Glide.with(context)
        .load(file.getUrl())
        .asBitmap()
        .dontAnimate()
        .into(photoView);

    container.addView(view);

    return view;
  }
}
