/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.schedulers;

import com.zoyi.rx.Scheduler;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.functions.Action0;
import com.zoyi.rx.subscriptions.BooleanSubscription;
import com.zoyi.rx.subscriptions.Subscriptions;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.TimeUnit;

public class TestScheduler
extends Scheduler {
    final Queue<TimedAction> queue = new PriorityQueue<TimedAction>(11, new CompareActionsByTime());
    static long counter;
    long time;

    @Override
    public long now() {
        return TimeUnit.NANOSECONDS.toMillis(this.time);
    }

    public void advanceTimeBy(long delayTime, TimeUnit unit) {
        this.advanceTimeTo(this.time + unit.toNanos(delayTime), TimeUnit.NANOSECONDS);
    }

    public void advanceTimeTo(long delayTime, TimeUnit unit) {
        long targetTime = unit.toNanos(delayTime);
        this.triggerActions(targetTime);
    }

    public void triggerActions() {
        this.triggerActions(this.time);
    }

    private void triggerActions(long targetTimeInNanos) {
        while (!this.queue.isEmpty()) {
            TimedAction current = this.queue.peek();
            if (current.time > targetTimeInNanos) break;
            this.time = current.time == 0L ? this.time : current.time;
            this.queue.remove();
            if (current.scheduler.isUnsubscribed()) continue;
            current.action.call();
        }
        this.time = targetTimeInNanos;
    }

    @Override
    public Scheduler.Worker createWorker() {
        return new InnerTestScheduler();
    }

    final class InnerTestScheduler
    extends Scheduler.Worker {
        private final BooleanSubscription s = new BooleanSubscription();

        InnerTestScheduler() {
        }

        @Override
        public void unsubscribe() {
            this.s.unsubscribe();
        }

        @Override
        public boolean isUnsubscribed() {
            return this.s.isUnsubscribed();
        }

        @Override
        public Subscription schedule(Action0 action, long delayTime, TimeUnit unit) {
            final TimedAction timedAction = new TimedAction(this, TestScheduler.this.time + unit.toNanos(delayTime), action);
            TestScheduler.this.queue.add(timedAction);
            return Subscriptions.create(new Action0(){

                @Override
                public void call() {
                    TestScheduler.this.queue.remove(timedAction);
                }
            });
        }

        @Override
        public Subscription schedule(Action0 action) {
            final TimedAction timedAction = new TimedAction(this, 0L, action);
            TestScheduler.this.queue.add(timedAction);
            return Subscriptions.create(new Action0(){

                @Override
                public void call() {
                    TestScheduler.this.queue.remove(timedAction);
                }
            });
        }

        @Override
        public long now() {
            return TestScheduler.this.now();
        }
    }

    static final class CompareActionsByTime
    implements Comparator<TimedAction> {
        CompareActionsByTime() {
        }

        @Override
        public int compare(TimedAction action1, TimedAction action2) {
            if (action1.time == action2.time) {
                return action1.count < action2.count ? -1 : (action1.count > action2.count ? 1 : 0);
            }
            return action1.time < action2.time ? -1 : (action1.time > action2.time ? 1 : 0);
        }
    }

    static final class TimedAction {
        final long time;
        final Action0 action;
        final Scheduler.Worker scheduler;
        private final long count = counter++;

        TimedAction(Scheduler.Worker scheduler, long time, Action0 action) {
            this.time = time;
            this.action = action;
            this.scheduler = scheduler;
        }

        public String toString() {
            return String.format("TimedAction(time = %d, action = %s)", this.time, this.action.toString());
        }
    }
}

