package com.zoyi.channel.plugin.android.activity.base;

import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.util.SortedListAdapterCallback;
import com.zoyi.channel.plugin.android.util.CompareUtils;

/**
 * Created by mika on 2016. 7. 5..
 */
public class SortedListCallback<E extends SortedItem> extends SortedListAdapterCallback<E> {
  private boolean desc;
  public SortedListCallback(RecyclerView.Adapter adapter, boolean desc) {
    super(adapter);
    this.desc = desc;
  }

  @Override
  public int compare(SortedItem o1, SortedItem o2) {
    int comp = CompareUtils.compare(o2.getFirst(), o1.getFirst());
    if (comp == 0) {
      return CompareUtils.compare(o2.getSecond(), o1.getSecond()) * (desc ? 1 : -1);
    }
    return comp * (desc ? 1 : -1);
  }

  @Override
  public boolean areContentsTheSame(SortedItem oldItem, SortedItem newItem) {
    return false;
  }

  @Override
  public boolean areItemsTheSame(SortedItem item1, SortedItem item2) {
    return CompareUtils.compare(item1.getSecond(), item2.getSecond()) == 0;
  }
}
