/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.observers.SerializedSubscriber;

public final class OperatorTakeUntil<T, E>
implements Observable.Operator<T, T> {
    private final Observable<? extends E> other;

    public OperatorTakeUntil(Observable<? extends E> other) {
        this.other = other;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super T> child) {
        final SerializedSubscriber<T> serial = new SerializedSubscriber<T>(child, false);
        final Subscriber main = new Subscriber<T>(serial, false){

            @Override
            public void onNext(T t) {
                serial.onNext(t);
            }

            @Override
            public void onError(Throwable e) {
                try {
                    serial.onError(e);
                }
                finally {
                    serial.unsubscribe();
                }
            }

            @Override
            public void onCompleted() {
                try {
                    serial.onCompleted();
                }
                finally {
                    serial.unsubscribe();
                }
            }
        };
        Subscriber so = new Subscriber<E>(){

            @Override
            public void onStart() {
                this.request(Long.MAX_VALUE);
            }

            @Override
            public void onCompleted() {
                main.onCompleted();
            }

            @Override
            public void onError(Throwable e) {
                main.onError(e);
            }

            @Override
            public void onNext(E t) {
                this.onCompleted();
            }
        };
        serial.add(main);
        serial.add(so);
        child.add(serial);
        this.other.unsafeSubscribe(so);
        return main;
    }
}

